/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyDecisionLogger;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PolicyList
extends ArrayList<PolicyIface>
implements PolicyIface {
    private static final Log log = LogFactory.getLog((String)PolicyList.class.getName());

    public PolicyList() {
    }

    public PolicyList(Collection<PolicyIface> policies) {
        super(policies);
    }

    @Override
    public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
        PolicyDecision pd = null;
        PolicyDecisionLogger logger = new PolicyDecisionLogger(whoToAuth, whatToAuth);
        for (PolicyIface policy : this) {
            try {
                pd = policy.isAuthorized(whoToAuth, whatToAuth);
                logger.log(policy, pd);
                if (pd != null) {
                    if (pd.getAuthorized() == Authorization.AUTHORIZED) {
                        return pd;
                    }
                    if (pd.getAuthorized() == Authorization.UNAUTHORIZED) {
                        return pd;
                    }
                    if (pd.getAuthorized() != Authorization.INCONCLUSIVE) continue;
                    continue;
                }
                log.debug((Object)("policy " + policy.toString() + " returned a null PolicyDecision"));
            }
            catch (Throwable th) {
                log.error((Object)("ignoring exception in policy " + policy.toString()), th);
            }
        }
        pd = new BasicPolicyDecision(Authorization.INCONCLUSIVE, "No policy returned a conclusive decision on " + whatToAuth);
        logger.logNoDecision(pd);
        return pd;
    }
}

