/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasAssociatedIndividual;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import java.util.Collection;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DisplayRestrictedDataToSelfPolicy
implements PolicyIface {
    private static final Log log = LogFactory.getLog(DisplayRestrictedDataToSelfPolicy.class);
    private final ServletContext ctx;

    public DisplayRestrictedDataToSelfPolicy(ServletContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
        if (whoToAuth == null) {
            return this.defaultDecision("whomToAuth was null");
        }
        if (whatToAuth == null) {
            return this.defaultDecision("whatToAuth was null");
        }
        Collection<String> associated = HasAssociatedIndividual.getIndividualUris(whoToAuth);
        if (associated.isEmpty()) {
            return this.defaultDecision("not self-editing for anyone");
        }
        if (whatToAuth instanceof DisplayDataProperty) {
            return this.defaultDecision("DataProperties have no associated 'self'");
        }
        if (whatToAuth instanceof DisplayObjectProperty) {
            return this.defaultDecision("ObjectProperties have no associated 'self'");
        }
        PolicyDecision result = whatToAuth instanceof DisplayDataPropertyStatement ? this.isAuthorized((DisplayDataPropertyStatement)whatToAuth, associated) : (whatToAuth instanceof DisplayObjectPropertyStatement ? this.isAuthorized((DisplayObjectPropertyStatement)whatToAuth, associated) : this.defaultDecision("Unrecognized action"));
        log.debug((Object)("decision for '" + whatToAuth + "' is " + result));
        return result;
    }

    private PolicyDecision isAuthorized(DisplayDataPropertyStatement action, Collection<String> individuals) {
        DataPropertyStatement stmt = action.getDataPropertyStatement();
        String subjectUri = stmt.getIndividualURI();
        Property predicate = new Property(stmt.getDatapropURI());
        if (this.canDisplayResource(subjectUri) && this.canDisplayPredicate(predicate) && this.isAboutAssociatedIndividual(individuals, subjectUri)) {
            return this.authorized("user may view DataPropertyStatement " + subjectUri + " ==> " + predicate.getURI());
        }
        return this.defaultDecision("user may not view DataPropertyStatement " + subjectUri + " ==> " + predicate.getURI());
    }

    private PolicyDecision isAuthorized(DisplayObjectPropertyStatement action, Collection<String> individuals) {
        String subjectUri = action.getSubjectUri();
        ObjectProperty predicate = action.getProperty();
        String objectUri = action.getObjectUri();
        if (this.canDisplayResource(subjectUri) && this.canDisplayPredicate(predicate) && this.canDisplayResource(objectUri) && this.isAboutAssociatedIndividual(individuals, subjectUri, objectUri)) {
            return this.authorized("user may view ObjectPropertyStatement " + subjectUri + " ==> " + predicate.getURI() + " ==> " + objectUri);
        }
        return this.defaultDecision("user may not view ObjectPropertyStatement " + subjectUri + " ==> " + predicate.getURI() + " ==> " + objectUri);
    }

    private PolicyDecision authorized(String message) {
        String className = this.getClass().getSimpleName();
        return new BasicPolicyDecision(Authorization.AUTHORIZED, className + ": " + message);
    }

    private PolicyDecision defaultDecision(String message) {
        return new BasicPolicyDecision(Authorization.INCONCLUSIVE, message);
    }

    private boolean canDisplayResource(String uri) {
        return PropertyRestrictionBean.getBean().canDisplayResource(uri, BaseResourceBean.RoleLevel.SELF);
    }

    private boolean canDisplayPredicate(Property predicate) {
        return PropertyRestrictionBean.getBean().canDisplayPredicate(predicate, BaseResourceBean.RoleLevel.SELF);
    }

    private boolean isAboutAssociatedIndividual(Collection<String> selves, String subjectUri) {
        for (String self : selves) {
            if (!self.equals(subjectUri)) continue;
            return true;
        }
        return false;
    }

    private boolean isAboutAssociatedIndividual(Collection<String> selves, String subjectUri, String objectUri) {
        for (String self : selves) {
            if (!self.equals(subjectUri) && !self.equals(objectUri)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.hashCode();
    }
}

