/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.permissions;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.Permission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBean;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractDataPropertyStatementAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractObjectPropertyStatementAction;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditByRolePermission
extends Permission {
    private static final Log log = LogFactory.getLog(EditByRolePermission.class);
    public static final String NAMESPACE = "java:" + EditByRolePermission.class.getName() + "#";
    private final String roleName;
    private final BaseResourceBean.RoleLevel roleLevel;

    public EditByRolePermission(String roleName, BaseResourceBean.RoleLevel roleLevel) {
        super(NAMESPACE + roleName);
        if (roleName == null) {
            throw new NullPointerException("role may not be null.");
        }
        if (roleLevel == null) {
            throw new NullPointerException("roleLevel may not be null.");
        }
        this.roleName = roleName;
        this.roleLevel = roleLevel;
    }

    @Override
    public boolean isAuthorized(RequestedAction whatToAuth) {
        boolean result = whatToAuth instanceof AbstractDataPropertyStatementAction ? this.isAuthorized((AbstractDataPropertyStatementAction)whatToAuth) : (whatToAuth instanceof AbstractObjectPropertyStatementAction ? this.isAuthorized((AbstractObjectPropertyStatementAction)whatToAuth) : false);
        if (result) {
            log.debug((Object)(this + " authorizes " + whatToAuth));
        } else {
            log.debug((Object)(this + " does not authorize " + whatToAuth));
        }
        return result;
    }

    private boolean isAuthorized(AbstractDataPropertyStatementAction action) {
        String subjectUri = action.getSubjectUri();
        Property predicate = action.getPredicate();
        return this.canModifyResource(subjectUri) && this.canModifyPredicate(predicate);
    }

    private boolean isAuthorized(AbstractObjectPropertyStatementAction action) {
        String subjectUri = action.getSubjectUri();
        Property predicate = action.getPredicate();
        String objectUri = action.getObjectUri();
        return this.canModifyResource(subjectUri) && this.canModifyPredicate(predicate) && this.canModifyResource(objectUri);
    }

    private boolean canModifyResource(String resourceUri) {
        return PropertyRestrictionBean.getBean().canModifyResource(resourceUri, this.roleLevel);
    }

    private boolean canModifyPredicate(Property predicate) {
        return PropertyRestrictionBean.getBean().canModifyPredicate(predicate, this.roleLevel);
    }

    @Override
    public String toString() {
        return "EditByRolePermission['" + this.roleName + "']";
    }
}

