/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import androidx.annotation.Nullable;
import java.io.FileDescriptor;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.MediaList;
import org.videolan.libvlc.VLCObject;
import org.videolan.libvlc.interfaces.ILibVLC;
import org.videolan.libvlc.interfaces.IMedia;
import org.videolan.libvlc.interfaces.IMediaList;
import org.videolan.libvlc.util.AndroidUtil;
import org.videolan.libvlc.util.HWDecoderUtil;
import org.videolan.libvlc.util.VLCUtil;

public class Media
extends VLCObject<IMedia.Event>
implements IMedia {
    private static final String TAG = "LibVLC/Media";
    private static final int PARSE_STATUS_INIT = 0;
    private static final int PARSE_STATUS_PARSING = 1;
    private static final int PARSE_STATUS_PARSED = 2;
    private Uri mUri = null;
    private MediaList mSubItems = null;
    private int mParseStatus = 0;
    private final String[] mNativeMetas = new String[25];
    private IMedia.Track[] mNativeTracks = null;
    private long mDuration = -1L;
    private int mState = -1;
    private int mType = -1;
    private boolean mCodecOptionSet = false;
    private boolean mFileCachingSet = false;
    private boolean mNetworkCachingSet = false;

    private static IMedia.Track createAudioTrackFromNative(String codec, String originalCodec, int fourcc, int id, int profile, int level, int bitrate, String language, String description, int channels, int rate) {
        return new IMedia.AudioTrack(codec, originalCodec, fourcc, id, profile, level, bitrate, language, description, channels, rate);
    }

    private static IMedia.Track createVideoTrackFromNative(String codec, String originalCodec, int fourcc, int id, int profile, int level, int bitrate, String language, String description, int height, int width, int sarNum, int sarDen, int frameRateNum, int frameRateDen, int orientation, int projection) {
        return new IMedia.VideoTrack(codec, originalCodec, fourcc, id, profile, level, bitrate, language, description, height, width, sarNum, sarDen, frameRateNum, frameRateDen, orientation, projection);
    }

    private static IMedia.Track createSubtitleTrackFromNative(String codec, String originalCodec, int fourcc, int id, int profile, int level, int bitrate, String language, String description, String encoding) {
        return new IMedia.SubtitleTrack(codec, originalCodec, fourcc, id, profile, level, bitrate, language, description, encoding);
    }

    private static IMedia.Track createUnknownTrackFromNative(String codec, String originalCodec, int fourcc, int id, int profile, int level, int bitrate, String language, String description) {
        return new IMedia.UnknownTrack(codec, originalCodec, fourcc, id, profile, level, bitrate, language, description);
    }

    private static IMedia.Slave createSlaveFromNative(int type, int priority, String uri) {
        return new IMedia.Slave(type, priority, uri);
    }

    private static IMedia.Stats createStatsFromNative(int readBytes, float inputBitrate, int demuxReadBytes, float demuxBitrates, int demuxCorrupted, int demuxDiscontinuity, int decodedVideo, int decodedAudio, int displayedPictures, int lostPictures, int playedAbuffers, int lostAbuffers, int sentPackets, int sentBytes, float sendBitrate) {
        return new IMedia.Stats(readBytes, inputBitrate, demuxReadBytes, demuxBitrates, demuxCorrupted, demuxDiscontinuity, decodedVideo, decodedAudio, displayedPictures, lostPictures, playedAbuffers, lostAbuffers, sentPackets, sentBytes, sendBitrate);
    }

    public Media(ILibVLC ILibVLC2, String path) {
        super(ILibVLC2);
        this.nativeNewFromPath(ILibVLC2, path);
        this.mUri = VLCUtil.UriFromMrl(this.nativeGetMrl());
    }

    public Media(ILibVLC ILibVLC2, Uri uri) {
        super(ILibVLC2);
        this.nativeNewFromLocation(ILibVLC2, VLCUtil.encodeVLCUri(uri));
        this.mUri = uri;
    }

    public Media(ILibVLC ILibVLC2, FileDescriptor fd) {
        super(ILibVLC2);
        this.nativeNewFromFd(ILibVLC2, fd);
        this.mUri = VLCUtil.UriFromMrl(this.nativeGetMrl());
    }

    public Media(ILibVLC ILibVLC2, AssetFileDescriptor afd) {
        super(ILibVLC2);
        long offset = afd.getStartOffset();
        long length = afd.getLength();
        this.nativeNewFromFdWithOffsetLength(ILibVLC2, afd.getFileDescriptor(), offset, length);
        this.mUri = VLCUtil.UriFromMrl(this.nativeGetMrl());
    }

    protected Media(IMediaList ml, int index) {
        super(ml);
        if (ml == null || ml.isReleased()) {
            throw new IllegalArgumentException("MediaList is null or released");
        }
        if (!ml.isLocked()) {
            throw new IllegalStateException("MediaList should be locked");
        }
        this.nativeNewFromMediaList(ml, index);
        this.mUri = VLCUtil.UriFromMrl(this.nativeGetMrl());
    }

    @Override
    public void setEventListener(IMedia.EventListener listener) {
        super.setEventListener(listener);
    }

    @Override
    protected synchronized IMedia.Event onEventNative(int eventType, long arg1, long arg2, float argf1, @Nullable String args1) {
        switch (eventType) {
            case 0: {
                int id = (int)arg1;
                if (id >= 0 && id < 25) {
                    this.mNativeMetas[id] = null;
                }
                return new IMedia.Event(eventType, arg1);
            }
            case 2: {
                this.mDuration = -1L;
                break;
            }
            case 3: {
                this.postParse();
                return new IMedia.Event(eventType, arg1);
            }
            case 5: {
                this.mState = -1;
            }
        }
        return new IMedia.Event(eventType);
    }

    @Override
    public synchronized Uri getUri() {
        return this.mUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDuration() {
        Media media = this;
        synchronized (media) {
            if (this.mDuration != -1L) {
                return this.mDuration;
            }
            if (this.isReleased()) {
                return 0L;
            }
        }
        long duration = this.nativeGetDuration();
        Media media2 = this;
        synchronized (media2) {
            this.mDuration = duration;
            return this.mDuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState() {
        Media media = this;
        synchronized (media) {
            if (this.mState != -1) {
                return this.mState;
            }
            if (this.isReleased()) {
                return 7;
            }
        }
        int state = this.nativeGetState();
        Media media2 = this;
        synchronized (media2) {
            this.mState = state;
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaList subItems() {
        Media media = this;
        synchronized (media) {
            if (this.mSubItems != null) {
                this.mSubItems.retain();
                return this.mSubItems;
            }
        }
        MediaList subItems = new MediaList(this);
        Media media2 = this;
        synchronized (media2) {
            this.mSubItems = subItems;
            this.mSubItems.retain();
            return this.mSubItems;
        }
    }

    private synchronized void postParse() {
        if ((this.mParseStatus & 2) != 0) {
            return;
        }
        this.mParseStatus &= 0xFFFFFFFE;
        this.mParseStatus |= 2;
        this.mNativeTracks = null;
        this.mDuration = -1L;
        this.mState = -1;
        this.mType = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parse(int flags) {
        boolean parse = false;
        Media media = this;
        synchronized (media) {
            if ((this.mParseStatus & 3) == 0) {
                this.mParseStatus |= 1;
                parse = true;
            }
        }
        if (parse && this.nativeParse(flags)) {
            this.postParse();
            return true;
        }
        return false;
    }

    @Override
    public boolean parse() {
        return this.parse(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseAsync(int flags, int timeout) {
        boolean parse = false;
        Media media = this;
        synchronized (media) {
            if ((this.mParseStatus & 3) == 0) {
                this.mParseStatus |= 1;
                parse = true;
            }
        }
        return parse && this.nativeParseAsync(flags, timeout);
    }

    @Override
    public boolean parseAsync(int flags) {
        return this.parseAsync(flags, -1);
    }

    @Override
    public boolean parseAsync() {
        return this.parseAsync(2);
    }

    @Override
    public synchronized boolean isParsed() {
        return (this.mParseStatus & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getType() {
        Media media = this;
        synchronized (media) {
            if (this.mType != -1) {
                return this.mType;
            }
            if (this.isReleased()) {
                return 0;
            }
        }
        int type = this.nativeGetType();
        Media media2 = this;
        synchronized (media2) {
            this.mType = type;
            return this.mType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMedia.Track[] getTracks() {
        Media media = this;
        synchronized (media) {
            if (this.mNativeTracks != null) {
                return this.mNativeTracks;
            }
            if (this.isReleased()) {
                return null;
            }
        }
        IMedia.Track[] tracks = this.nativeGetTracks();
        Media media2 = this;
        synchronized (media2) {
            this.mNativeTracks = tracks;
            return this.mNativeTracks;
        }
    }

    @Override
    public int getTrackCount() {
        IMedia.Track[] tracks = this.getTracks();
        return tracks != null ? tracks.length : 0;
    }

    @Override
    public IMedia.Track getTrack(int idx) {
        IMedia.Track[] tracks = this.getTracks();
        if (tracks == null || idx < 0 || idx >= tracks.length) {
            return null;
        }
        return tracks[idx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMeta(int id) {
        if (id < 0 || id >= 25) {
            return null;
        }
        Media media = this;
        synchronized (media) {
            if (this.mNativeMetas[id] != null) {
                return this.mNativeMetas[id];
            }
            if (this.isReleased()) {
                return null;
            }
        }
        String meta = this.nativeGetMeta(id);
        Media media2 = this;
        synchronized (media2) {
            this.mNativeMetas[id] = meta;
            return meta;
        }
    }

    private static String getMediaCodecModule() {
        return AndroidUtil.isLolliPopOrLater ? "mediacodec_ndk" : "mediacodec_jni";
    }

    @Override
    public void setHWDecoderEnabled(boolean enabled, boolean force) {
        if (LibVLC.majorVersion() == 3) {
            HWDecoderUtil.Decoder decoder;
            HWDecoderUtil.Decoder decoder2 = decoder = enabled ? HWDecoderUtil.getDecoderFromDevice() : HWDecoderUtil.Decoder.NONE;
            if (decoder == HWDecoderUtil.Decoder.UNKNOWN && force) {
                decoder = HWDecoderUtil.Decoder.ALL;
            }
            if (decoder == HWDecoderUtil.Decoder.NONE || decoder == HWDecoderUtil.Decoder.UNKNOWN) {
                this.addOption(":codec=all");
                return;
            }
            if (!this.mFileCachingSet) {
                this.addOption(":file-caching=1500");
            }
            if (!this.mNetworkCachingSet) {
                this.addOption(":network-caching=1500");
            }
            StringBuilder sb = new StringBuilder(":codec=");
            if (decoder == HWDecoderUtil.Decoder.MEDIACODEC || decoder == HWDecoderUtil.Decoder.ALL) {
                sb.append(Media.getMediaCodecModule()).append(",");
            }
            if (force && (decoder == HWDecoderUtil.Decoder.OMX || decoder == HWDecoderUtil.Decoder.ALL)) {
                sb.append("iomx,");
            }
            sb.append("all");
            this.addOption(sb.toString());
        } else if (!enabled) {
            this.addOption(":no-hw-dec");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultMediaPlayerOptions() {
        if (LibVLC.majorVersion() == 3) {
            boolean codecOptionSet;
            Media media = this;
            synchronized (media) {
                codecOptionSet = this.mCodecOptionSet;
                this.mCodecOptionSet = true;
            }
            if (!codecOptionSet) {
                this.setHWDecoderEnabled(true, false);
            }
        }
        if (this.mUri != null && this.mUri.getScheme() != null && !this.mUri.getScheme().equalsIgnoreCase("file") && this.mUri.getLastPathSegment() != null && this.mUri.getLastPathSegment().toLowerCase().endsWith(".iso")) {
            this.addOption(":demux=dvdnav,any");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOption(String option) {
        Media media = this;
        synchronized (media) {
            if (!this.mCodecOptionSet && option.startsWith(":codec=")) {
                this.mCodecOptionSet = true;
            }
            if (!this.mNetworkCachingSet && option.startsWith(":network-caching=")) {
                this.mNetworkCachingSet = true;
            }
            if (!this.mFileCachingSet && option.startsWith(":file-caching=")) {
                this.mFileCachingSet = true;
            }
        }
        this.nativeAddOption(option);
    }

    @Override
    public void addSlave(IMedia.Slave slave) {
        this.nativeAddSlave(slave.type, slave.priority, slave.uri);
    }

    @Override
    public void clearSlaves() {
        this.nativeClearSlaves();
    }

    @Override
    @Nullable
    public IMedia.Slave[] getSlaves() {
        return this.nativeGetSlaves();
    }

    @Override
    @Nullable
    public IMedia.Stats getStats() {
        return this.nativeGetStats();
    }

    @Override
    protected void onReleaseNative() {
        if (this.mSubItems != null) {
            this.mSubItems.release();
        }
        this.nativeRelease();
    }

    private native void nativeNewFromPath(ILibVLC var1, String var2);

    private native void nativeNewFromLocation(ILibVLC var1, String var2);

    private native void nativeNewFromFd(ILibVLC var1, FileDescriptor var2);

    private native void nativeNewFromFdWithOffsetLength(ILibVLC var1, FileDescriptor var2, long var3, long var5);

    private native void nativeNewFromMediaList(IMediaList var1, int var2);

    private native void nativeRelease();

    private native boolean nativeParseAsync(int var1, int var2);

    private native boolean nativeParse(int var1);

    private native String nativeGetMrl();

    private native int nativeGetState();

    private native String nativeGetMeta(int var1);

    private native IMedia.Track[] nativeGetTracks();

    private native long nativeGetDuration();

    private native int nativeGetType();

    private native void nativeAddOption(String var1);

    private native void nativeAddSlave(int var1, int var2, String var3);

    private native void nativeClearSlaves();

    private native IMedia.Slave[] nativeGetSlaves();

    private native IMedia.Stats nativeGetStats();
}

