/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.jtar;

import java.io.File;
import java.util.Date;
import org.unfoldingword.tools.jtar.Octal;
import org.unfoldingword.tools.jtar.PermissionUtils;
import org.unfoldingword.tools.jtar.TarHeader;

public class TarEntry {
    protected File file = null;
    protected TarHeader header;

    private TarEntry() {
        this.header = new TarHeader();
    }

    public TarEntry(File file, String entryName) {
        this();
        this.file = file;
        this.extractTarHeader(entryName);
    }

    public TarEntry(byte[] headerBuf) {
        this();
        this.parseTarHeader(headerBuf);
    }

    public TarEntry(TarHeader header) {
        this.header = header;
    }

    public boolean equals(TarEntry it) {
        return this.header.name.toString().equals(it.header.name.toString());
    }

    public boolean isDescendent(TarEntry desc) {
        return desc.header.name.toString().startsWith(this.header.name.toString());
    }

    public TarHeader getHeader() {
        return this.header;
    }

    public String getName() {
        String name = this.header.name.toString();
        if (this.header.namePrefix != null && !this.header.namePrefix.toString().equals("")) {
            name = this.header.namePrefix.toString() + "/" + name;
        }
        return name;
    }

    public void setName(String name) {
        this.header.name = new StringBuffer(name);
    }

    public int getUserId() {
        return this.header.userId;
    }

    public void setUserId(int userId) {
        this.header.userId = userId;
    }

    public int getGroupId() {
        return this.header.groupId;
    }

    public void setGroupId(int groupId) {
        this.header.groupId = groupId;
    }

    public String getUserName() {
        return this.header.userName.toString();
    }

    public void setUserName(String userName) {
        this.header.userName = new StringBuffer(userName);
    }

    public String getGroupName() {
        return this.header.groupName.toString();
    }

    public void setGroupName(String groupName) {
        this.header.groupName = new StringBuffer(groupName);
    }

    public void setIds(int userId, int groupId) {
        this.setUserId(userId);
        this.setGroupId(groupId);
    }

    public void setModTime(long time) {
        this.header.modTime = time / 1000L;
    }

    public void setModTime(Date time) {
        this.header.modTime = time.getTime() / 1000L;
    }

    public Date getModTime() {
        return new Date(this.header.modTime * 1000L);
    }

    public File getFile() {
        return this.file;
    }

    public long getSize() {
        return this.header.size;
    }

    public void setSize(long size) {
        this.header.size = size;
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.header != null) {
            if (this.header.linkFlag == 53) {
                return true;
            }
            if (this.header.name.toString().endsWith("/")) {
                return true;
            }
        }
        return false;
    }

    public void extractTarHeader(String entryName) {
        int permissions = PermissionUtils.permissions(this.file);
        this.header = TarHeader.createHeader(entryName, this.file.length(), this.file.lastModified() / 1000L, this.file.isDirectory(), permissions);
    }

    public long computeCheckSum(byte[] buf) {
        long sum = 0L;
        for (int i = 0; i < buf.length; ++i) {
            sum += (long)(0xFF & buf[i]);
        }
        return sum;
    }

    public void writeEntryHeader(byte[] outbuf) {
        int offset = 0;
        offset = TarHeader.getNameBytes(this.header.name, outbuf, offset, 100);
        offset = Octal.getOctalBytes(this.header.mode, outbuf, offset, 8);
        offset = Octal.getOctalBytes(this.header.userId, outbuf, offset, 8);
        offset = Octal.getOctalBytes(this.header.groupId, outbuf, offset, 8);
        long size = this.header.size;
        offset = Octal.getLongOctalBytes(size, outbuf, offset, 12);
        int csOffset = offset = Octal.getLongOctalBytes(this.header.modTime, outbuf, offset, 12);
        for (int c = 0; c < 8; ++c) {
            outbuf[offset++] = 32;
        }
        outbuf[offset++] = this.header.linkFlag;
        offset = TarHeader.getNameBytes(this.header.linkName, outbuf, offset, 100);
        offset = TarHeader.getNameBytes(this.header.magic, outbuf, offset, 8);
        offset = TarHeader.getNameBytes(this.header.userName, outbuf, offset, 32);
        offset = TarHeader.getNameBytes(this.header.groupName, outbuf, offset, 32);
        offset = Octal.getOctalBytes(this.header.devMajor, outbuf, offset, 8);
        offset = Octal.getOctalBytes(this.header.devMinor, outbuf, offset, 8);
        offset = TarHeader.getNameBytes(this.header.namePrefix, outbuf, offset, 155);
        while (offset < outbuf.length) {
            outbuf[offset++] = 0;
        }
        long checkSum = this.computeCheckSum(outbuf);
        Octal.getCheckSumOctalBytes(checkSum, outbuf, csOffset, 8);
    }

    public void parseTarHeader(byte[] bh) {
        int offset = 0;
        this.header.name = TarHeader.parseName(bh, offset, 100);
        this.header.mode = (int)Octal.parseOctal(bh, offset += 100, 8);
        this.header.userId = (int)Octal.parseOctal(bh, offset += 8, 8);
        this.header.groupId = (int)Octal.parseOctal(bh, offset += 8, 8);
        this.header.size = Octal.parseOctal(bh, offset += 8, 12);
        this.header.modTime = Octal.parseOctal(bh, offset += 12, 12);
        this.header.checkSum = (int)Octal.parseOctal(bh, offset += 12, 8);
        offset += 8;
        this.header.linkFlag = bh[offset++];
        this.header.linkName = TarHeader.parseName(bh, offset, 100);
        this.header.magic = TarHeader.parseName(bh, offset += 100, 8);
        this.header.userName = TarHeader.parseName(bh, offset += 8, 32);
        this.header.groupName = TarHeader.parseName(bh, offset += 32, 32);
        this.header.devMajor = (int)Octal.parseOctal(bh, offset += 32, 8);
        this.header.devMinor = (int)Octal.parseOctal(bh, offset += 8, 8);
        this.header.namePrefix = TarHeader.parseName(bh, offset += 8, 155);
    }
}

