/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.resourcecontainer;

import android.util.Log;
import com.esotericsoftware.yamlbeans.YamlWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.unfoldingword.resourcecontainer.FileUtil;
import org.unfoldingword.resourcecontainer.ObjectReader;
import org.unfoldingword.resourcecontainer.ResourceContainer;

public class ContainerTools {
    private static final String TAG = ContainerTools.class.getName();

    public static JSONObject inspect(File containerPath) throws Exception {
        ResourceContainer container;
        if (!containerPath.exists()) {
            throw new Exception("The resource container does not exist at " + containerPath.getAbsolutePath());
        }
        if (containerPath.isFile()) {
            String[] nameArray = containerPath.getName().split("\\.");
            String ext = nameArray[nameArray.length - 1];
            if (!ext.equals("tsrc")) {
                throw new Exception("Invalid resource container file extension");
            }
            nameArray[nameArray.length - 1] = "";
            File containerDir = new File(containerPath.getParentFile(), containerPath.getName() + ".inspect.tmp");
            container = ResourceContainer.open(containerPath, containerDir);
            FileUtil.deleteQuietly(containerDir);
        } else {
            container = ResourceContainer.load(containerPath);
        }
        return container.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceContainer convertResource(String data, File directory, JSONObject props) throws Exception {
        if (!(props.has("language") && props.has("project") && props.has("resource") && props.getJSONObject("resource").has("type"))) {
            throw new Exception("Missing required parameters");
        }
        JSONObject project = props.getJSONObject("project");
        JSONObject language = props.getJSONObject("language");
        JSONObject resource = props.getJSONObject("resource");
        if (!language.has("direction") && language.has("dir")) {
            language.put("direction", (Object)language.getString("dir"));
            language.remove("dir");
        }
        String mimeType = !project.getString("slug").equals("obs") && resource.getString("type").equals("book") ? "text/usx" : "text/markdown";
        String chunkExt = mimeType.equals("text/usx") ? "usx" : "md";
        File containerArchive = new File(directory.getParentFile(), directory.getName() + "." + "tsrc");
        if (containerArchive.exists()) {
            throw new Exception("Resource container already exists");
        }
        try {
            JSONObject json;
            FileUtil.deleteQuietly(directory);
            directory.mkdirs();
            JSONObject packageData = new JSONObject();
            packageData.put("package_version", (Object)"0.1");
            packageData.put("modified_at", props.get("modified_at"));
            packageData.put("content_mime_type", (Object)mimeType);
            packageData.put("language", (Object)language);
            packageData.put("project", (Object)project);
            packageData.put("resource", (Object)resource);
            packageData.put("chunk_status", (Object)new JSONArray());
            FileUtil.writeStringToFile(new File(directory, "package.json"), packageData.toString(2).replace("\\", ""));
            FileUtil.writeStringToFile(new File(directory, "LICENSE.md"), resource.getJSONObject("status").getString("license"));
            File contentDir = new File(directory, "content");
            contentDir.mkdirs();
            HashMap config = new HashMap();
            ArrayList toc = new ArrayList();
            if (!resource.getString("type").equals("help") && !resource.getString("type").equals("dict")) {
                File frontDir = new File(contentDir, "front");
                frontDir.mkdirs();
                FileUtil.writeStringToFile(new File(frontDir, "title." + chunkExt), project.getString("name").trim());
            }
            if (resource.getString("type").equals("book")) {
                json = new JSONObject(data);
                config.put("content", new HashMap());
                if (project.getString("slug").equals("obs")) {
                    HashMap<String, Object> mediaConfig = new HashMap<String, Object>();
                    mediaConfig.put("mime_type", "image/jpg");
                    mediaConfig.put("size", 37620940);
                    mediaConfig.put("url", "https://api.unfoldingword.org/obs/jpg/1/en/obs-images-360px.zip");
                    config.put("media", mediaConfig);
                }
                for (int c = 0; c < json.getJSONArray("chapters").length(); ++c) {
                    JSONObject chapter = json.getJSONArray("chapters").getJSONObject(c);
                    HashMap chapterConfig = new HashMap();
                    String chapterNumber = ContainerTools.normalizeSlug(chapter.getString("number"));
                    File chapterDir = new File(contentDir, chapterNumber);
                    chapterDir.mkdirs();
                    if (chapter.has("title") && !chapter.getString("title").isEmpty()) {
                        FileUtil.writeStringToFile(new File(chapterDir, "title." + chunkExt), chapter.getString("title"));
                    } else {
                        String title = ContainerTools.localizeChapterTitle(language.getString("slug"), chapterNumber);
                        FileUtil.writeStringToFile(new File(chapterDir, "title." + chunkExt), title);
                    }
                    for (int f = 0; f < chapter.getJSONArray("frames").length(); ++f) {
                        JSONObject frame = chapter.getJSONArray("frames").getJSONObject(f);
                        String frameSlug = ContainerTools.normalizeSlug(frame.getString("id").split("-")[1].trim());
                        if (frameSlug.equals("00")) {
                            Pattern versePattern = Pattern.compile("<verse\\s+number=\"(\\d+(-\\d+)?)\"\\s+style=\"v\"\\s*\\/>");
                            String frameText = frame.getString("text");
                            Matcher match = versePattern.matcher(frameText = frameText.replace("\\\"", "\""));
                            if (match.find()) {
                                String firstVerseRange = match.group(1);
                                frameSlug = ContainerTools.normalizeSlug(firstVerseRange.split("-")[0]);
                            }
                        }
                        ArrayList questions = new ArrayList();
                        ArrayList notes = new ArrayList();
                        ArrayList images = new ArrayList();
                        ArrayList<Object> words = new ArrayList<Object>();
                        if (props.has("tw_assignments")) {
                            try {
                                JSONArray slugs = props.getJSONObject("tw_assignments").getJSONObject(chapterNumber).getJSONArray(frameSlug);
                                for (int s = 0; s < slugs.length(); ++s) {
                                    words.add(slugs.get(s));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (questions.size() > 0 || notes.size() > 0 || images.size() > 0 || words.size() > 0) {
                            chapterConfig.put(frameSlug, new HashMap());
                        }
                        if (questions.size() > 0) {
                            ((HashMap)chapterConfig.get(frameSlug)).put("questions", questions);
                        }
                        if (notes.size() > 0) {
                            ((HashMap)chapterConfig.get(frameSlug)).put("notes", notes);
                        }
                        if (images.size() > 0) {
                            ((HashMap)chapterConfig.get(frameSlug)).put("images", images);
                        }
                        if (words.size() > 0) {
                            ((HashMap)chapterConfig.get(frameSlug)).put("words", words);
                        }
                        FileUtil.writeStringToFile(new File(chapterDir, frameSlug + "." + chunkExt), frame.getString("text"));
                    }
                    if (chapter.has("ref") && !chapter.getString("ref").isEmpty()) {
                        FileUtil.writeStringToFile(new File(chapterDir, "title." + chunkExt), chapter.getString("title"));
                    }
                    if (chapterConfig.size() <= 0) continue;
                    ((Map)config.get("content")).put(chapterNumber, chapterConfig);
                }
            } else if (resource.getString("type").equals("help")) {
                json = new JSONArray(data);
                if (resource.getString("slug").equals("tn")) {
                    for (int c = 0; c < json.length(); ++c) {
                        String[] slugs;
                        JSONObject chunk = json.getJSONObject(c);
                        if (!chunk.has("tn") || (slugs = chunk.getString("id").split("-")).length != 2) continue;
                        String chapterSlug = ContainerTools.normalizeSlug(slugs[0]);
                        String chunkSlug = ContainerTools.normalizeSlug(slugs[1]);
                        if (chunkSlug.equals("00")) continue;
                        File chapterDir = new File(contentDir, chapterSlug);
                        chapterDir.mkdirs();
                        String body = "";
                        for (int n = 0; n < chunk.getJSONArray("tn").length(); ++n) {
                            JSONObject note = chunk.getJSONArray("tn").getJSONObject(n);
                            body = body + "\n\n#" + note.getString("ref") + "\n\n" + note.getString("text");
                        }
                        if (body.trim().isEmpty()) continue;
                        FileUtil.writeStringToFile(new File(chapterDir, chunkSlug + "." + chunkExt), body.trim());
                    }
                } else {
                    if (!resource.getString("slug").equals("tq")) throw new Exception("Unsupported resource " + resource.getString("slug"));
                    ObjectReader reader = ContainerTools.convertTQ(data);
                    List<Object> chapters = reader.keys();
                    for (Object chapter : chapters) {
                        List<Object> chunks = reader.get(chapter).keys();
                        for (Object chunk : chunks) {
                            File chunkFile = new File(new File(contentDir, (String)chapter), chunk + "." + chunkExt);
                            chunkFile.getParentFile().mkdirs();
                            FileUtil.writeStringToFile(chunkFile, reader.get(chapter).get(chunk).toString());
                        }
                    }
                }
            } else if (resource.getString("type").equals("dict")) {
                json = new JSONArray(data);
                for (int w = 0; w < json.length(); ++w) {
                    int i;
                    JSONObject word = json.getJSONObject(w);
                    if (!word.has("id")) continue;
                    File wordDir = new File(contentDir, word.getString("id"));
                    wordDir.mkdirs();
                    String body = "#" + word.getString("term") + "\n\n" + word.getString("def");
                    FileUtil.writeStringToFile(new File(wordDir, "01." + chunkExt), body);
                    HashMap<String, Object> wordConfig = new HashMap<String, Object>();
                    wordConfig.put("def_title", word.getString("def_title"));
                    if (ContainerTools.JSONHasLength(word, "cf")) {
                        wordConfig.put("see_also", new ArrayList());
                        for (i = 0; i < word.getJSONArray("cf").length(); ++i) {
                            String[] parts = word.getJSONArray("cf").getString(i).split("\\|");
                            String[] id = parts[0].toLowerCase();
                            if (((List)wordConfig.get("see_also")).contains(id)) continue;
                            ((List)wordConfig.get("see_also")).add(id);
                        }
                    }
                    if (ContainerTools.JSONHasLength(word, "aliases")) {
                        wordConfig.put("aliases", new ArrayList());
                        for (i = 0; i < word.getJSONArray("aliases").length(); ++i) {
                            String[] aliases;
                            for (String alias : aliases = word.getJSONArray("aliases").getString(i).split(",")) {
                                ((List)wordConfig.get("aliases")).add(alias.trim());
                            }
                        }
                    }
                    if (ContainerTools.JSONHasLength(word, "ex")) {
                        wordConfig.put("examples", new ArrayList());
                        for (i = 0; i < word.getJSONArray("ex").length(); ++i) {
                            JSONObject example = word.getJSONArray("ex").getJSONObject(i);
                            if (!example.has("ref")) continue;
                            ((List)wordConfig.get("examples")).add(example.getString("ref"));
                        }
                    }
                    config.put(word.getString("id"), wordConfig);
                }
            } else {
                if (!resource.getString("type").equals("man")) throw new Exception("Unsupported resource container type " + resource.getString("type"));
                json = new JSONObject(data);
                HashMap tocMap = new HashMap();
                config.put("content", new HashMap());
                for (int a = 0; a < json.getJSONArray("articles").length(); ++a) {
                    JSONObject article = json.getJSONArray("articles").getJSONObject(a);
                    HashMap articleConfig = new HashMap();
                    ArrayList<String> recommended = new ArrayList<String>();
                    ArrayList<String> dependencies = new ArrayList<String>();
                    String slug = article.getString("id").replaceAll("\\_", "-");
                    if (article.has("recommend") && !article.isNull("recommend")) {
                        for (int i = 0; i < article.getJSONArray("recommend").length(); ++i) {
                            recommended.add(article.getJSONArray("recommend").getString(i).replaceAll("\\_", "-"));
                        }
                    }
                    if (article.has("depend") && !article.isNull("depend")) {
                        for (int i = 0; i < article.getJSONArray("depend").length(); ++i) {
                            dependencies.add(article.getJSONArray("depend").getString(i).replaceAll("\\_", "-"));
                        }
                    }
                    File articleDir = new File(contentDir, slug);
                    articleDir.mkdirs();
                    FileUtil.writeStringToFile(new File(articleDir, "title." + chunkExt), article.getString("title"));
                    FileUtil.writeStringToFile(new File(articleDir, "sub-title." + chunkExt), article.getString("question"));
                    FileUtil.writeStringToFile(new File(articleDir, "01." + chunkExt), article.getString("text"));
                    if (recommended.size() > 0 || dependencies.size() > 0) {
                        articleConfig.put("recommended", recommended);
                        articleConfig.put("dependencies", dependencies);
                        ((HashMap)config.get("content")).put(slug, articleConfig);
                    }
                    HashMap<String, Object> articleTOC = new HashMap<String, Object>();
                    articleTOC.put("chapter", slug);
                    ArrayList<String> chunkTOC = new ArrayList<String>();
                    chunkTOC.add("title");
                    chunkTOC.add("sub-title");
                    chunkTOC.add("01");
                    articleTOC.put("chunks", chunkTOC);
                    tocMap.put(article.getString("id"), articleTOC);
                }
                Pattern linkPattern = Pattern.compile("\\[[^\\[\\]]*\\]\\s*\\(([^\\(\\)]*)\\)", 32);
                Matcher match = linkPattern.matcher(json.getString("toc"));
                while (match.find()) {
                    String key = match.group(1);
                    Object val = tocMap.get(key);
                    if (val == null) continue;
                    toc.add(val);
                }
            }
            try (YamlWriter configWriter = null;){
                configWriter = new YamlWriter((Writer)new FileWriter(new File(contentDir, "config.yml")));
                configWriter.write(config);
            }
            if (toc.size() <= 0) return ResourceContainer.load(directory);
            try (YamlWriter tocWriter = null;){
                tocWriter = new YamlWriter((Writer)new FileWriter(new File(contentDir, "toc.yml")));
                tocWriter.write(toc);
                return ResourceContainer.load(directory);
            }
        }
        catch (Exception e) {
            FileUtil.deleteQuietly(directory);
            throw e;
        }
    }

    public static String localizeChapterTitle(String languageSlug, String chapterNumber) {
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.put("ar", "\u0627\u0644\u0641\u0635\u0644 %");
        translations.put("en", "Chapter %");
        translations.put("ru", "\u0413\u043b\u0430\u0432\u0430 %");
        translations.put("hu", "%. fejezet");
        translations.put("sr-Latin", "\u041f\u043e\u0433\u043b\u0430\u0432\u0459\u0435 %");
        translations.put("default", "Chapter %");
        String title = (String)translations.get(languageSlug);
        if (title == null) {
            title = (String)translations.get("default");
        }
        try {
            int num = Integer.parseInt(chapterNumber);
            return title.replace("%", num + "");
        }
        catch (NumberFormatException e) {
            return title.replace("%", chapterNumber);
        }
    }

    public static String normalizeSlug(String slug) throws Exception {
        if (slug == null || slug.isEmpty()) {
            throw new Exception("slug cannot be an empty string");
        }
        if (!ContainerTools.isInteger(slug)) {
            return slug;
        }
        slug = slug.replaceAll("^(0+)", "").trim();
        while (slug.length() < 2) {
            slug = "0" + slug;
        }
        return slug;
    }

    protected static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    public static String localizeChapterTitle(String languageSlug, int chapterNumber) {
        return ContainerTools.localizeChapterTitle(languageSlug, chapterNumber + "");
    }

    private static boolean JSONHasLength(JSONObject json, String key) {
        try {
            return json.has(key) && json.optJSONArray(key) != null && json.getJSONArray(key).length() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String makeSlug(String languageSlug, String projectSlug, String resourceSlug) {
        if (languageSlug == null || languageSlug.isEmpty() || projectSlug == null || projectSlug.isEmpty() || resourceSlug == null || resourceSlug.isEmpty()) {
            throw new InvalidParameterException("Invalid resource container slug parameters");
        }
        return languageSlug + "_" + projectSlug + "_" + resourceSlug;
    }

    public static String[] explodeSlug(String resourceContainerSlug) {
        return resourceContainerSlug.split("_");
    }

    public static String mimeToType(String mimeType) {
        return mimeType.split("\\+")[1];
    }

    public static String typeToMime(String resourceType) {
        return "application/tsrc+" + resourceType;
    }

    public static ObjectReader convertTQ(String tqstring) throws JSONException {
        ObjectReader reader = new ObjectReader(new JSONArray(tqstring));
        HashMap normalizedChapters = new HashMap();
        for (ObjectReader chapter : reader) {
            if (chapter.get("cq").value() == null) continue;
            try {
                String chapterId = ContainerTools.normalizeSlug((String)chapter.get("id").value());
                HashMap<String, String> normalizedChunks = new HashMap<String, String>();
                for (ObjectReader question : chapter.get("cq")) {
                    String text = "\n\n#" + question.get("q") + "\n\n" + question.get("a");
                    for (ObjectReader ref : question.get("ref")) {
                        String[] slugs = ref.toString().split("-");
                        if (slugs.length != 2) continue;
                        String chunkId = ContainerTools.normalizeSlug(slugs[1]);
                        String old = (String)normalizedChunks.get(chunkId);
                        normalizedChunks.put(chunkId, (old != null ? old.trim() : "") + text);
                    }
                }
                normalizedChapters.put(chapterId, normalizedChunks);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"tQ parsing failed");
                e.printStackTrace();
            }
        }
        return new ObjectReader(normalizedChapters);
    }
}

