/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.http;

import android.util.Base64;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public abstract class Request {
    private final URL url;
    private final String requestMethod;
    private String auth = null;
    private String contentType = null;
    private int responseCode = -1;
    private String responseMessage = null;
    private int ttl = 5000;
    private OnProgressListener progressListener = null;

    public Request(URL url, String requestMethod) {
        this.url = url;
        this.requestMethod = requestMethod.toUpperCase();
    }

    public void setAuth(String token) {
        this.setAuth(token, "Bearer");
    }

    public void setAuth(String token, String label) {
        this.auth = label + " " + token;
    }

    public void setCredentials(String username, String password) throws UnsupportedEncodingException {
        String credentials = username + ":" + password;
        String token = Base64.encodeToString((byte[])credentials.getBytes("UTF-8"), (int)2);
        this.setAuth(token, "Basic");
    }

    public void setTimeout(int ttl) {
        this.ttl = ttl;
    }

    public void setProgressListener(OnProgressListener listener) {
        this.progressListener = listener;
    }

    public void setAuthentication(String token) {
        this.setAuth(token, "token");
    }

    public void setAuthentication(String username, String password) {
        try {
            this.setCredentials(username, password);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.auth = null;
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected HttpURLConnection openConnection() throws IOException {
        HttpURLConnection conn = this.url.getProtocol().equals("https") ? (HttpsURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection();
        if (this.auth != null) {
            conn.setRequestProperty("Authorization", this.auth);
        }
        if (this.contentType != null) {
            conn.setRequestProperty("Content-Type", this.contentType);
        }
        conn.setRequestMethod(this.requestMethod);
        conn.setConnectTimeout(this.ttl);
        conn.setReadTimeout(this.ttl);
        try {
            this.onConnected(conn);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.responseCode = conn.getResponseCode();
            this.responseMessage = conn.getResponseMessage();
        }
        return conn;
    }

    protected void writeData(HttpURLConnection connection, String data) throws IOException {
        connection.setDoOutput(true);
        DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
        dos.writeBytes(data);
        dos.flush();
        dos.close();
    }

    public final void download(File destination) throws IOException {
        HttpURLConnection connection = this.openConnection();
        int responseSize = connection.getContentLength();
        destination.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(destination);
        int updateInterval = 52400;
        int updateQueue = 0;
        int bytesRead = 0;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(connection.getInputStream());
            byte[] buffer = new byte[4096];
            int n = 0;
            while ((n = ((InputStream)in).read(buffer)) != -1) {
                bytesRead += n;
                out.write(buffer, 0, n);
                if ((updateQueue += n) < updateInterval) continue;
                updateQueue = 0;
                this.publishProgress(responseSize, bytesRead);
            }
            this.publishProgress(responseSize, bytesRead);
        }
        catch (Exception e) {
            if (in != null) {
                ((InputStream)in).close();
            }
            out.close();
            connection.disconnect();
            if (destination.exists()) {
                destination.delete();
            }
            throw e;
        }
        if (in != null) {
            ((InputStream)in).close();
        }
        out.close();
        connection.disconnect();
    }

    public final String read() throws IOException {
        HttpURLConnection connection = this.openConnection();
        int responseSize = connection.getContentLength();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int updateInterval = 52400;
        int updateQueue = 0;
        int bytesRead = 0;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(connection.getInputStream());
            int n = 0;
            while ((n = in.read()) != -1) {
                out.write((byte)n);
                if (updateQueue < updateInterval) continue;
                updateQueue = 0;
                this.publishProgress(responseSize, bytesRead);
            }
            this.publishProgress(responseSize, bytesRead);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
            out.close();
            connection.disconnect();
        }
        return out.toString("UTF-8");
    }

    private void publishProgress(long totalBytes, long bytesRead) {
        if (this.progressListener == null) {
            return;
        }
        if (totalBytes <= 0L || bytesRead <= 0L) {
            this.progressListener.onIndeterminate();
        } else {
            this.progressListener.onProgress(totalBytes, bytesRead);
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    protected abstract void onConnected(HttpURLConnection var1) throws IOException;

    public static interface OnProgressListener {
        public void onProgress(long var1, long var3);

        public void onIndeterminate();
    }
}

