/*
 * Decompiled with CFR 0.152.
 */
package org.unfoldingword.tools.http;

import android.util.Base64;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

abstract class Request {
    private final URL url;
    private final String requestMethod;
    private String token;
    private String username;
    private String password;
    private String contentType = null;
    private HttpURLConnection connection;
    private int responseCode = -1;

    public Request(URL url, String requestMethod) {
        this.url = url;
        this.requestMethod = requestMethod.toUpperCase();
    }

    public void setAuthentication(String token) {
        this.token = token;
    }

    public void setAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected String getAuth() {
        if (this.token != null) {
            return "token " + this.token;
        }
        if (this.username != null && this.password != null) {
            String credentials = this.username + ":" + this.password;
            try {
                return "Basic " + Base64.encodeToString((byte[])credentials.getBytes("UTF-8"), (int)2);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected void openConnection() throws IOException {
        HttpURLConnection conn = this.url.getProtocol() == "https" ? (HttpsURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection();
        String auth = this.getAuth();
        if (auth != null) {
            conn.setRequestProperty("Authorization", auth);
        }
        if (this.contentType != null) {
            conn.setRequestProperty("Content-Type", this.contentType);
        }
        conn.setRequestMethod(this.requestMethod);
        this.connection = conn;
    }

    protected String readResponse() throws IOException {
        int current;
        InputStream is = this.connection.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((current = bis.read()) != -1) {
            baos.write((byte)current);
        }
        this.connection.disconnect();
        return baos.toString("UTF-8");
    }

    protected void sendData(String data) throws IOException {
        this.connection.setDoOutput(true);
        DataOutputStream dos = new DataOutputStream(this.connection.getOutputStream());
        dos.writeBytes(data);
        dos.flush();
        dos.close();
    }

    public final String submit() throws IOException {
        this.openConnection();
        String response = this.onSubmit(this.connection);
        this.responseCode = this.connection.getResponseCode();
        return response;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    protected abstract String onSubmit(HttpURLConnection var1) throws IOException;
}

