/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetalsp.examples.streamingdatasource;

import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.uma.jmetalsp.ObservedData;
import org.uma.jmetalsp.StreamingDataSource;
import org.uma.jmetalsp.observeddata.SingleObservedData;
import org.uma.jmetalsp.observer.Observable;
import org.uma.jmetalsp.observer.impl.DefaultObservable;

public class SimpleStreamingDataSourceFromKeyboard
implements StreamingDataSource<SingleObservedData<List<Double>>> {
    private Observable<SingleObservedData<List<Double>>> observable;

    public SimpleStreamingDataSourceFromKeyboard(Observable<SingleObservedData<List<Double>>> observable) {
        this.observable = observable;
    }

    public SimpleStreamingDataSourceFromKeyboard() {
        this((Observable<SingleObservedData<List<Double>>>)new DefaultObservable());
    }

    public void run() {
        Scanner scanner = new Scanner(System.in);
        while (true) {
            double v2;
            double v1;
            System.out.println("Introduce the new reference point(between commas):");
            String s = scanner.nextLine();
            Scanner sl = new Scanner(s);
            sl.useDelimiter(",");
            try {
                v1 = Double.parseDouble(sl.next());
                v2 = Double.parseDouble(sl.next());
            }
            catch (Exception e) {
                v1 = 0.0;
                v2 = 0.0;
            }
            System.out.println("REF POINT: " + v1 + ", " + v2);
            this.observable.setChanged();
            List<Double> values = Arrays.asList(v1, v2);
            this.observable.notifyObservers((ObservedData)new SingleObservedData(values));
        }
    }

    public Observable<SingleObservedData<List<Double>>> getObservable() {
        return this.observable;
    }
}

