/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginRedirectServlet
extends HttpServlet {
    public static final String DISPLAY_AFTER_LOGIN_INIT_PARAM = "display-after-login";
    public static final String DISPLAY_WHEN_NOT_AUTH_INIT_PARAM = "display-when-not-authenticated";
    private static final Logger logger = LoggerFactory.getLogger(LoginRedirectServlet.class);
    private String displayAfterLoginUri;
    private String displayWhenNotAuthenticatedUri;

    private static String extractParameters(HttpServletRequest fromRequest) {
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry param : fromRequest.getParameterMap().entrySet()) {
                String paramName = URLEncoder.encode((String)param.getKey(), "UTF-8");
                if (paramName.equals("j_username") || paramName.equals("j_password")) continue;
                for (String value : (String[])param.getValue()) {
                    if (sb.length() != 0) {
                        sb.append("&");
                    }
                    sb.append(paramName).append("=").append(URLEncoder.encode(value, "UTF-8"));
                }
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported on this JVM?");
        }
    }

    public void init(ServletConfig config) throws ServletException {
        String contextRelativeHostPageUri = config.getInitParameter(DISPLAY_AFTER_LOGIN_INIT_PARAM);
        if (contextRelativeHostPageUri == null) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " requires that you set the init parameter \"" + DISPLAY_AFTER_LOGIN_INIT_PARAM + "\" to the context-relative URI of the host page.");
        }
        this.displayAfterLoginUri = config.getServletContext().getContextPath() + contextRelativeHostPageUri;
        String contextRelativeNotAuthPageUri = config.getInitParameter(DISPLAY_WHEN_NOT_AUTH_INIT_PARAM);
        if (contextRelativeNotAuthPageUri != null) {
            this.displayWhenNotAuthenticatedUri = config.getServletContext().getContextPath() + contextRelativeNotAuthPageUri;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.displayWhenNotAuthenticatedUri != null && req.getUserPrincipal() == null) {
            logger.debug("No authorized user thus cleaning up session and redirecting to " + this.displayWhenNotAuthenticatedUri);
            try {
                req.logout();
                req.getSession().invalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            resp.sendRedirect(this.displayWhenNotAuthenticatedUri);
            return;
        }
        logger.debug("Redirecting " + req.getUserPrincipal() + " to " + this.displayAfterLoginUri);
        StringBuilder redirectTarget = new StringBuilder(this.displayAfterLoginUri);
        String extraParams = LoginRedirectServlet.extractParameters(req);
        if (extraParams.length() > 0) {
            redirectTarget.append("?").append(extraParams);
        }
        resp.sendRedirect(redirectTarget.toString());
    }
}

