/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.mojoexecutor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenCompatibilityHelper {
    private static Method getRepositorySession;
    private static Method loadPlugin;

    public static PluginDescriptor loadPluginDescriptor(Plugin plugin, MojoExecutor.ExecutionEnvironment env, MavenSession session) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException, PluginNotFoundException {
        try {
            Object repositorySession = getRepositorySession.invoke((Object)session, new Object[0]);
            BuildPluginManager pluginManager = env.getPluginManager();
            return (PluginDescriptor)loadPlugin.invoke((Object)pluginManager, plugin, env.getMavenProject().getRemotePluginRepositories(), repositorySession);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        for (Method m : MavenSession.class.getMethods()) {
            if (!"getRepositorySession".equals(m.getName())) continue;
            getRepositorySession = m;
            break;
        }
        if (getRepositorySession == null) {
            throw new ExceptionInInitializerError("Unable to locate getRepositorySession method");
        }
        for (Method m : BuildPluginManager.class.getMethods()) {
            if (!"loadPlugin".equals(m.getName())) continue;
            loadPlugin = m;
            break;
        }
        if (loadPlugin == null) {
            throw new ExceptionInInitializerError("Unable to locate loadPluginDescriptor method");
        }
    }
}

