/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.io.File;
import java.util.Map;
import org.apache.maven.Maven;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.cli.PhaseCall;
import org.twdata.maven.cli.console.CliConsole;

public class PhaseCallRunner {
    private final MavenSession session;
    private final MavenProject project;
    private final File userDir;
    private boolean pluginExecutionOfflineMode;

    public PhaseCallRunner(MavenSession session, MavenProject project) {
        this.session = session;
        this.project = project;
        this.userDir = new File(System.getProperty("user.dir"));
        this.pluginExecutionOfflineMode = session.getSettings().isOffline();
    }

    public void run(MavenProject currentProject, PhaseCall phaseCall, CliConsole console) {
        try {
            this.session.getExecutionProperties().putAll((Map<?, ?>)phaseCall.getProperties());
            this.session.setCurrentProject(currentProject);
            this.session.getSettings().setOffline(phaseCall.isOffline() ? true : this.pluginExecutionOfflineMode);
            DefaultProfileManager profileManager = new DefaultProfileManager(this.session.getContainer(), phaseCall.getProperties());
            profileManager.explicitlyActivate(phaseCall.getProfiles());
            DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest(this.session.getLocalRepository(), this.session.getSettings(), this.session.getEventDispatcher(), phaseCall.getPhases(), this.userDir.getPath(), (ProfileManager)profileManager, this.session.getExecutionProperties(), this.project.getProperties(), true);
            if (!phaseCall.isRecursive()) {
                request.setRecursive(false);
            }
            request.setPomFile(new File(currentProject.getBasedir(), "pom.xml").getPath());
            ((Maven)this.session.lookup(Maven.ROLE)).execute((MavenExecutionRequest)request);
            console.writeInfo("Current project: " + this.project.getArtifactId());
        }
        catch (Exception e) {
            console.writeError("Failed to execute '" + phaseCall.getPhases() + "' on '" + currentProject.getArtifactId() + "'");
        }
    }
}

