/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.MavenProject;
import org.shaded.mojoexecutor.MojoExecutor;

public class MojoCall {
    private final String groupId;
    private final String artifactId;
    private final String goal;

    public MojoCall(String groupId, String artifactId, String goal) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.goal = goal;
    }

    public void run(MavenProject project, MavenSession session, PluginManager pluginManager) throws MojoExecutionException {
        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId(this.groupId), MojoExecutor.artifactId(this.artifactId), MojoExecutor.version(this.getVersion(project))), MojoExecutor.goal(this.goal), MojoExecutor.configuration(new MojoExecutor.Element[0]), MojoExecutor.executionEnvironment(project, session, pluginManager));
    }

    private String getVersion(MavenProject project) {
        String version = null;
        List plugins = project.getBuildPlugins();
        for (Plugin plugin : plugins) {
            if (!this.groupId.equals(plugin.getGroupId()) || !this.artifactId.equals(plugin.getArtifactId())) continue;
            version = plugin.getVersion();
            break;
        }
        if (version == null) {
            plugins = project.getPluginManagement().getPlugins();
            for (Plugin plugin : plugins) {
                if (!this.groupId.equals(plugin.getGroupId()) || !this.artifactId.equals(plugin.getArtifactId())) continue;
                version = plugin.getVersion();
                break;
            }
        }
        if (version == null) {
            version = "RELEASE";
        }
        return version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(":").append(this.artifactId);
        sb.append(" [").append(this.goal).append("]");
        return sb.toString();
    }
}

