/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.testing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.metadata.enums.EnumFeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Validate;

public class TestFeatureManager
implements FeatureManager {
    private final Class<? extends Feature> featureEnum;
    private final Set<String> activeFeatures = new HashSet<String>();

    public TestFeatureManager(Class<? extends Feature> featureEnum) {
        Validate.notNull(featureEnum, (String)"The featureEnum argument is required");
        Validate.isTrue((boolean)featureEnum.isEnum(), (String)"This feature manager currently only works with feature enums");
        this.featureEnum = featureEnum;
    }

    public String getName() {
        return this.getClass().getSimpleName() + ":" + this.featureEnum.getSimpleName();
    }

    public Set<Feature> getFeatures() {
        return new HashSet<Feature>(Arrays.asList(this.featureEnum.getEnumConstants()));
    }

    public FeatureMetaData getMetaData(Feature feature) {
        return new EnumFeatureMetaData(feature);
    }

    public boolean isActive(Feature feature) {
        return this.activeFeatures.contains(feature.name());
    }

    public FeatureUser getCurrentFeatureUser() {
        return null;
    }

    public FeatureState getFeatureState(Feature feature) {
        return new FeatureState(feature, this.isActive(feature));
    }

    public void setFeatureState(FeatureState state) {
        if (state.isEnabled()) {
            this.activeFeatures.add(state.getFeature().name());
        } else {
            this.activeFeatures.remove(state.getFeature().name());
        }
    }

    public List<ActivationStrategy> getActivationStrategies() {
        return null;
    }

    public TestFeatureManager enable(Feature feature) {
        this.activeFeatures.add(feature.name());
        return this;
    }

    public TestFeatureManager disable(Feature feature) {
        this.activeFeatures.remove(feature.name());
        return this;
    }

    public TestFeatureManager enableAll() {
        for (Feature feature : this.featureEnum.getEnumConstants()) {
            this.enable(feature);
        }
        return this;
    }

    public TestFeatureManager disableAll() {
        this.activeFeatures.clear();
        return this;
    }
}

