/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.token;

import java.util.List;
import org.togglz.console.shade.jmte.TemplateContext;
import org.togglz.console.shade.jmte.token.AbstractToken;
import org.togglz.console.shade.jmte.token.IfToken;

public class IfCmpToken
extends IfToken {
    private final AbstractToken operand;

    public IfCmpToken(String expression, AbstractToken operand, boolean negated) {
        super(expression, negated);
        this.operand = operand;
    }

    public IfCmpToken(List<String> segments, String expression, AbstractToken operand, boolean negated) {
        super(segments, expression, negated);
        this.operand = operand;
    }

    public String getOperand(TemplateContext context) {
        return this.operand == null ? "true" : this.operand.evaluate(context).toString();
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = String.format("if %s='%s'", this.getExpression(), this.operand == null ? "" : this.operand.getText());
        }
        return this.text;
    }

    @Override
    public Object evaluate(TemplateContext context) {
        boolean condition;
        Object value = this.evaluatePlain(context);
        boolean bl = condition = value != null && this.getOperand(context).equals(value.toString());
        Boolean evaluated = this.negated ? !condition : condition;
        return evaluated;
    }
}

