/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.tinylog.Level;
import org.tinylog.core.LogEntry;
import org.tinylog.path.DynamicPath;
import org.tinylog.policies.Policy;
import org.tinylog.policies.StartupPolicy;
import org.tinylog.provider.InternalLogger;
import org.tinylog.runtime.RuntimeProvider;
import org.tinylog.writers.AbstractFormatPatternWriter;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class RollingFileWriter
extends AbstractFormatPatternWriter {
    private final DynamicPath path;
    private final List<Policy> policies;
    private final int backups;
    private final boolean buffered;
    private final boolean writingThread;
    private final Charset charset;
    private ByteArrayWriter writer;

    public RollingFileWriter() throws FileNotFoundException {
        this(Collections.emptyMap());
    }

    public RollingFileWriter(Map<String, String> properties) throws FileNotFoundException {
        super(properties);
        boolean append;
        String fileName;
        this.path = new DynamicPath(RollingFileWriter.getFileName(properties));
        this.policies = RollingFileWriter.createPolicies(properties.get("policies"));
        this.backups = properties.containsKey("backups") ? Integer.parseInt(properties.get("backups")) : -1;
        List<File> files = this.path.getAllFiles();
        if (files.size() > 0 && this.path.isValid(files.get(0))) {
            fileName = files.get(0).getPath();
            if (RollingFileWriter.canBeContinued(fileName, this.policies)) {
                append = true;
                RollingFileWriter.deleteBackups(files.subList(1, files.size()), this.backups);
            } else {
                fileName = this.path.resolve();
                append = false;
                RollingFileWriter.deleteBackups(files, this.backups);
            }
        } else {
            fileName = this.path.resolve();
            append = false;
        }
        this.charset = RollingFileWriter.getCharset(properties);
        this.buffered = Boolean.parseBoolean(properties.get("buffered"));
        this.writingThread = Boolean.parseBoolean(properties.get("writingthread"));
        this.writer = RollingFileWriter.createByteArrayWriter(fileName, append, this.buffered, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LogEntry logEntry) throws IOException {
        byte[] data = this.render(logEntry).getBytes(this.charset);
        if (this.writingThread) {
            this.internalWrite(data);
        } else {
            ByteArrayWriter byteArrayWriter = this.writer;
            synchronized (byteArrayWriter) {
                this.internalWrite(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.writingThread) {
            this.internalFlush();
        } else {
            ByteArrayWriter byteArrayWriter = this.writer;
            synchronized (byteArrayWriter) {
                this.internalFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.writingThread) {
            this.internalClose();
        } else {
            ByteArrayWriter byteArrayWriter = this.writer;
            synchronized (byteArrayWriter) {
                this.internalClose();
            }
        }
    }

    private void internalWrite(byte[] data) throws IOException {
        if (!RollingFileWriter.canBeContinued(data, this.policies)) {
            this.writer.close();
            String fileName = this.path.resolve();
            RollingFileWriter.deleteBackups(this.path.getAllFiles(), this.backups);
            this.writer = RollingFileWriter.createByteArrayWriter(fileName, false, this.buffered, false, false);
            for (Policy policy : this.policies) {
                policy.reset();
            }
        }
        this.writer.write(data, data.length);
    }

    private void internalFlush() throws IOException {
        this.writer.flush();
    }

    private void internalClose() throws IOException {
        this.writer.close();
    }

    private static List<Policy> createPolicies(String property) {
        if (property == null || property.isEmpty()) {
            return Collections.singletonList(new StartupPolicy(null));
        }
        if (RuntimeProvider.getProcessId() == Long.MIN_VALUE) {
            ServiceLoader.load(Policy.class);
        }
        return new org.tinylog.configuration.ServiceLoader(Policy.class, new Class[]{String.class}).createList(property);
    }

    private static boolean canBeContinued(String fileName, List<Policy> policies) {
        boolean result = true;
        for (Policy policy : policies) {
            result &= policy.continueExistingFile(fileName);
        }
        return result;
    }

    private static boolean canBeContinued(byte[] data, List<Policy> policies) {
        boolean result = true;
        for (Policy policy : policies) {
            result &= policy.continueCurrentFile(data);
        }
        return result;
    }

    private static void deleteBackups(List<File> files, int count) {
        if (count >= 0) {
            for (int i = files.size() - Math.max(0, files.size() - count); i < files.size(); ++i) {
                if (files.get(i).delete()) continue;
                InternalLogger.log((Level)Level.WARN, (String)("Failed to delete log file '" + files.get(i).getAbsolutePath() + "'"));
            }
        }
    }
}

