/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

final class PackageNameToken
implements Token {
    PackageNameToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.CLASS);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        String packageName = PackageNameToken.getPackage(logEntry.getClassName());
        if (packageName != null) {
            builder.append(packageName);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        statement.setString(index, PackageNameToken.getPackage(logEntry.getClassName()));
    }

    private static String getPackage(String fullyQualifiedClassName) {
        int dotIndex = fullyQualifiedClassName.lastIndexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return fullyQualifiedClassName.substring(0, dotIndex);
    }
}

