/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.serviceplugin;

import java.util.Map;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.cepcore.EventProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.plugin.PluginManager;
import org.tinygroup.plugin.config.PluginService;
import org.tinygroup.plugin.impl.BasePlugin;
import org.tinygroup.service.ServiceProviderInterface;
import org.tinygroup.serviceplugin.processor.ServiceProcessor;
import org.tinygroup.serviceplugin.processor.impl.ServiceProcessorImpl;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicePlugin
extends BasePlugin {
    private static Logger logger = LoggerFactory.getLogger(ServicePlugin.class);
    private CEPCore cepcore;
    private ServiceProcessor processor;

    public void init() {
        super.init();
        XmlNode config = this.getXmlNodeConfig();
        this.initProcessors(config);
    }

    public void start() {
        logger.logMessage(LogLevel.DEBUG, "\u542f\u52a8ServicePlugin");
        this.cepcore.registerEventProcessor((EventProcessor)this.processor);
        logger.logMessage(LogLevel.DEBUG, "\u542f\u52a8ServicePlugin\u5b8c\u6210");
    }

    protected ClassLoader getThisClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    private void initProcessors(XmlNode config) {
        logger.logMessage(LogLevel.DEBUG, "\u521d\u59cb\u5316ServiceProcessor");
        this.processor = new ServiceProcessorImpl();
        this.processor.setConfig(config);
        Map map = super.getServiceInstanceMap();
        for (Map.Entry<PluginService, Object> entry : map.entrySet()) {
            this.dealExecutor(entry);
        }
        logger.logMessage(LogLevel.DEBUG, "\u521d\u59cb\u5316ServiceProcessor\u5b8c\u6210");
    }

    private void dealExecutor(Map.Entry<PluginService, Object> entry) {
        ServiceProviderInterface provider = (ServiceProviderInterface)entry.getValue();
        PluginService service = entry.getKey();
        logger.logMessage(LogLevel.DEBUG, "\u5904\u7406ServicePlugin\u7684Service[id:{0},version:{1}]", new Object[]{service.getId(), service.getVersion()});
        this.processor.addServiceProvider(provider);
        logger.logMessage(LogLevel.DEBUG, "\u5904\u7406ServicePlugin\u7684Service[id:{0},version:{1}]\u5b8c\u6210", new Object[]{service.getId(), service.getVersion()});
    }

    public void pause() {
        logger.logMessage(LogLevel.DEBUG, "\u6682\u505cServicePlugin");
        this.cepcore.unregisterEventProcessor((EventProcessor)this.processor);
        logger.logMessage(LogLevel.DEBUG, "\u6682\u505cServicePlugin\u5b8c\u6210");
    }

    public void stop() {
        logger.logMessage(LogLevel.DEBUG, "\u505c\u6b62ServicePlugin");
        this.cepcore.unregisterEventProcessor((EventProcessor)this.processor);
        logger.logMessage(LogLevel.DEBUG, "\u505c\u6b62ServicePlugin\u5b8c\u6210");
    }

    public void destroy() {
        logger.logMessage(LogLevel.DEBUG, "\u9500\u6bc1ServicePlugin");
        super.destroy();
        logger.logMessage(LogLevel.DEBUG, "\u9500\u6bc1ServicePlugin\u5b8c\u6210");
    }

    public <T> void setService(T service, Class<T> clazz) {
        if (CEPCore.class.isAssignableFrom(clazz)) {
            this.cepcore = service == null ? null : (CEPCore)service;
        }
    }

    private XmlNode getXmlNodeConfig() {
        PluginManager pluginManager = (PluginManager)SpringUtil.getBean((String)"pluginManager");
        XmlNode config = pluginManager.getConifg(this.getPluginInfo());
        return config;
    }
}

