/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.fileresolver.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.tinygroup.commons.order.OrderUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.ChangeListener;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.FileResolverUtil;
import org.tinygroup.fileresolver.ProcessorCallBack;
import org.tinygroup.fileresolver.impl.MultiThreadFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResolverImpl
implements FileResolver {
    private static final String FILE_RESOLVER_CONFIG = "/application/file-resolver-configuration";
    private static final int DEFAULT_THREAD_NUM = 1;
    ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResolverImpl.class);
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private int fileProcessorThreadNum = 1;
    private List<FileProcessor> fileProcessorList = new ArrayList<FileProcessor>();
    private Map<String, Long> fileDateMap = new HashMap<String, Long>();
    private Map<String, FileObject> fileObjectCaches = new HashMap<String, FileObject>();
    private Map<String, Pattern> includePathPatternMap = new HashMap<String, Pattern>();
    private List<String> allScanningPath = new ArrayList<String>();
    private XmlNode componentConfig;
    private XmlNode applicationConfig;
    private ClassLoader classLoader;

    @Override
    public List<ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public void setChangeListeners(List<ChangeListener> changeListeners) {
        this.changeListeners = changeListeners;
    }

    @Override
    public List<String> getScanningPaths() {
        return this.allScanningPath;
    }

    @Override
    public List<FileProcessor> getFileProcessorList() {
        return this.fileProcessorList;
    }

    public void setFileProcessorList(List<FileProcessor> fileProcessorList) {
        this.fileProcessorList = fileProcessorList;
    }

    public FileResolverImpl() {
        String classPath = "[\\/]classes\\b";
        this.includePathPatternMap.put(classPath, Pattern.compile(classPath));
        classPath = "[\\/]test-classes\\b";
        this.includePathPatternMap.put(classPath, Pattern.compile(classPath));
    }

    public FileResolverImpl(boolean b) {
    }

    @Override
    public void addFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessorList.add(fileProcessor);
        fileProcessor.setFileResolver(this);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public void resolve() {
        if (!this.fileProcessorList.isEmpty()) {
            for (FileProcessor fileProcessor : this.fileProcessorList) {
                fileProcessor.setFileResolver(this);
            }
            OrderUtil.order(this.fileProcessorList);
            this.cleanProcessor();
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u8fdb\u884c\u5168\u8def\u5f84\u626b\u63cf....");
            this.resolverScanPath();
            for (FileProcessor fileProcessor : this.fileProcessorList) {
                fileProcessor.process();
            }
            LOGGER.logMessage(LogLevel.INFO, "\u5168\u8def\u5f84\u626b\u63cf\u5b8c\u6210\u3002");
        }
    }

    private void refreshScanPath() {
        HashSet<FileObject> classPaths = new HashSet<FileObject>();
        for (String filePath : this.allScanningPath) {
            FileObject fileObject = VFS.resolveFile((String)filePath);
            Long lastModifiedTime = this.fileDateMap.get(fileObject.getAbsolutePath());
            long modifiedTime = fileObject.getLastModifiedTime();
            if (lastModifiedTime == modifiedTime && fileObject.isInPackage()) continue;
            this.fileDateMap.put(fileObject.getAbsolutePath(), modifiedTime);
            if (!fileObject.isExist()) continue;
            classPaths.add(fileObject);
        }
        this.resolveClassPaths(classPaths);
        this.change();
    }

    private void resolverScanPath() {
        HashSet<FileObject> classPaths = new HashSet<FileObject>();
        for (String filePath : this.allScanningPath) {
            FileObject fileObject = VFS.resolveFile((String)filePath);
            classPaths.add(fileObject);
            long modifiedTime = fileObject.getLastModifiedTime();
            this.fileDateMap.put(fileObject.getAbsolutePath(), modifiedTime);
        }
        this.resolveClassPaths(classPaths);
    }

    private void cleanProcessor() {
        for (FileProcessor fileProcessor : this.fileProcessorList) {
            fileProcessor.clean();
        }
    }

    private void resolveClassPaths(Set<FileObject> classPaths) {
        ArrayList<FileObject> scanPathsList = new ArrayList<FileObject>();
        scanPathsList.addAll(classPaths);
        MultiThreadFileProcessor.multiProcessor(this.fileProcessorThreadNum, "file-resolver-threads", scanPathsList, new ProcessorCallBack(){

            public void callBack(FileObject fileObject) {
                LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u626b\u63cf\u8def\u5f84[{0}]...", new Object[]{fileObject.getAbsolutePath()});
                FileResolverImpl.this.resolveFileObject(fileObject);
                LOGGER.logMessage(LogLevel.INFO, "\u8def\u5f84[{0}]\u626b\u63cf\u5b8c\u6210\u3002", new Object[]{fileObject.getAbsolutePath()});
            }
        });
    }

    private void resolveFileObject(FileObject fileObject) {
        LOGGER.logMessage(LogLevel.DEBUG, "\u627e\u5230\u6587\u4ef6\uff1a{}", new Object[]{fileObject.getAbsolutePath().toString()});
        this.processFile(fileObject);
        if (fileObject.isFolder() && fileObject.getChildren() != null) {
            for (FileObject f : fileObject.getChildren()) {
                if (!this.allScanningPath.contains(f.getAbsolutePath())) {
                    if (!FileResolverUtil.isInclude(f, this)) continue;
                    this.resolveFileObject(f);
                    continue;
                }
                LOGGER.logMessage(LogLevel.INFO, "\u6587\u4ef6:[{}]\u5728\u626b\u63cf\u6839\u8def\u5f84\u5217\u8868\u4e2d\u5b58\u5728\uff0c\u5c06\u4f5c\u4e3a\u6839\u8def\u5f84\u8fdb\u884c\u626b\u63cf", new Object[]{f.getAbsolutePath()});
            }
            return;
        }
    }

    private void resolveDeletedFile() {
        HashMap<String, FileObject> tempMap = new HashMap<String, FileObject>();
        for (String path : this.fileObjectCaches.keySet()) {
            FileObject fileObject = this.fileObjectCaches.get(path);
            if (!fileObject.isExist()) {
                for (FileProcessor fileProcessor : this.fileProcessorList) {
                    if (!fileProcessor.isMatch(fileObject)) continue;
                    fileProcessor.delete(fileObject);
                }
                continue;
            }
            tempMap.put(path, fileObject);
        }
        this.fileObjectCaches = tempMap;
    }

    private synchronized void processFile(FileObject fileObject) {
        if (fileObject.isExist()) {
            String absolutePath = fileObject.getAbsolutePath();
            Long lastModifiedTime = this.fileDateMap.get(absolutePath);
            long modifiedTime = fileObject.getLastModifiedTime();
            for (FileProcessor fileProcessor : this.fileProcessorList) {
                if (!fileProcessor.isMatch(fileObject)) continue;
                if (lastModifiedTime == null) {
                    this.addFile(fileObject, fileProcessor);
                    continue;
                }
                if (lastModifiedTime != modifiedTime) {
                    this.changeFile(absolutePath, fileObject, fileProcessor);
                    continue;
                }
                this.noChangeFile(fileObject, fileProcessor);
            }
            this.fileDateMap.put(absolutePath, modifiedTime);
            this.fileObjectCaches.put(absolutePath, fileObject);
        }
    }

    private void noChangeFile(FileObject fileObject, FileProcessor fileProcessor) {
        fileProcessor.noChange(fileObject);
    }

    private void changeFile(String path, FileObject fileObject, FileProcessor fileProcessor) {
        fileProcessor.delete(this.fileObjectCaches.get(path));
        this.fileObjectCaches.remove(path);
        fileProcessor.modify(fileObject);
    }

    private void addFile(FileObject fileObject, FileProcessor fileProcessor) {
        fileProcessor.add(fileObject);
    }

    @Override
    public void addIncludePathPattern(String pattern) {
        this.includePathPatternMap.put(pattern, Pattern.compile(pattern));
    }

    @Override
    public void addResolveFileObject(FileObject fileObject) {
        String path = fileObject.getAbsolutePath();
        if (!this.allScanningPath.contains(path)) {
            this.allScanningPath.add(path);
        }
    }

    @Override
    public void addResolvePath(String path) {
        this.addResolveFileObject(VFS.resolveFile((String)path));
    }

    @Override
    public void addResolvePath(List<String> paths) {
        for (String path : paths) {
            this.addResolveFileObject(VFS.resolveFile((String)path));
        }
    }

    @Override
    public int getFileProcessorThreadNumber() {
        return this.fileProcessorThreadNum;
    }

    @Override
    public void setFileProcessorThreadNumber(int threadNum) {
        this.fileProcessorThreadNum = threadNum;
    }

    @Override
    public void refresh() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        if (this.fileProcessorList.isEmpty()) {
            return;
        }
        LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u8fdb\u884c\u5168\u8def\u5f84\u5237\u65b0....");
        this.cleanProcessor();
        this.resolveDeletedFile();
        this.refreshScanPath();
        for (FileProcessor fileProcessor : this.fileProcessorList) {
            if (!fileProcessor.supportRefresh()) continue;
            fileProcessor.process();
        }
        LOGGER.logMessage(LogLevel.INFO, "\u5168\u8def\u5f84\u5237\u65b0\u7ed3\u675f....");
    }

    public String getApplicationNodePath() {
        return FILE_RESOLVER_CONFIG;
    }

    public String getComponentConfigPath() {
        return "/fileresolver.config.xml";
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
        this.initConfig();
    }

    private void initConfig() {
        String resolveClassPath = ConfigurationUtil.getPropertyName((XmlNode)this.applicationConfig, (XmlNode)this.componentConfig, (String)"resolve-classpath");
        if (StringUtil.isBlank((String)resolveClassPath) || "true".equals(resolveClassPath)) {
            this.addResolvePath(FileResolverUtil.getClassPath(this));
        }
        String threadCount = ConfigurationUtil.getPropertyName((XmlNode)this.applicationConfig, (XmlNode)this.componentConfig, (String)"thread-count");
        this.setFileProcessorThreadNumber(this.getThreadNumber(threadCount));
        List classPaths = ConfigurationUtil.combineFindNodeList((String)"class-path", (XmlNode)this.applicationConfig, (XmlNode)this.componentConfig);
        for (XmlNode classPath : classPaths) {
            String path = classPath.getAttribute("path");
            if (path == null || path.length() <= 0) continue;
            LOGGER.logMessage(LogLevel.INFO, "\u6dfb\u52a0\u624b\u5de5\u914d\u7f6eclasspath: [{0}]...", new Object[]{path});
            this.addResolvePath(path);
        }
        List includePatterns = ConfigurationUtil.combineFindNodeList((String)"include-pattern", (XmlNode)this.applicationConfig, (XmlNode)this.componentConfig);
        for (XmlNode includePatter : includePatterns) {
            String pattern = includePatter.getAttribute("pattern");
            if (pattern == null || pattern.length() <= 0) continue;
            LOGGER.logMessage(LogLevel.INFO, "\u6dfb\u52a0\u5305\u542b\u6587\u4ef6\u6b63\u5219\u8868\u8fbe\u5f0f: [{0}]...", new Object[]{pattern});
            this.addIncludePathPattern(pattern);
        }
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    private int getThreadNumber(String threadNumber) {
        int threadNum = 1;
        if (threadNumber != null) {
            try {
                threadNum = Integer.parseInt(threadNumber);
                if (threadNum <= 0) {
                    threadNum = 1;
                }
            }
            catch (Exception e) {
                threadNum = 1;
            }
        }
        return threadNum;
    }

    @Override
    public Map<String, Pattern> getIncludePathPatternMap() {
        return this.includePathPatternMap;
    }

    @Override
    @Deprecated
    public void addChangeLisenter(ChangeListener listener) {
        this.addChangeListener(listener);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void change() {
        for (ChangeListener changeLisenter : this.changeListeners) {
            changeLisenter.change(this);
        }
    }

    private void removeFile(FileObject fileObject) {
        this.fileObjectCaches.remove(fileObject.getPath());
        for (FileProcessor fileProcessor : this.fileProcessorList) {
            if (!fileProcessor.isMatch(fileObject)) continue;
            fileProcessor.delete(fileObject);
        }
        if (fileObject.getChildren() != null) {
            for (FileObject child : fileObject.getChildren()) {
                this.removeFile(child);
            }
        }
    }

    @Override
    public void removeResolvePath(String path) {
        FileObject fileObject = VFS.resolveFile((String)path);
        String filePath = fileObject.getAbsolutePath();
        this.allScanningPath.remove(filePath);
        for (FileProcessor fileProcessor : this.fileProcessorList) {
            fileProcessor.clean();
        }
        this.removeFile(fileObject);
        for (FileProcessor fileProcessor : this.fileProcessorList) {
            if (!fileProcessor.supportRefresh()) continue;
            fileProcessor.process();
        }
    }
}

