/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.resource;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ClassPathFileTestResource;
import org.thymeleaf.testing.templateengine.resource.IClassPathTestResource;
import org.thymeleaf.testing.templateengine.resource.ILocalTestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceResolver;
import org.thymeleaf.testing.templateengine.resource.LocalFileTestResource;
import org.thymeleaf.testing.templateengine.resource.LocalFolderTestResource;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public class StandardTestResourceResolver
implements ITestResourceResolver {
    public static final StandardTestResourceResolver UTF8_RESOLVER = new StandardTestResourceResolver("UTF-8");
    public static final StandardTestResourceResolver ISO8859_1_RESOLVER = new StandardTestResourceResolver("ISO-8859-1");
    private static final String CLASSPATH_RESOURCE_PREFIX = "classpath:";
    private static final String FILE_RESOURCE_PREFIX = "file:";
    private final String characterEncoding;

    public StandardTestResourceResolver(String characterEncoding) {
        Validate.notNull((Object)characterEncoding, (String)"Character encoding cannot be null");
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    private boolean hasPrefix(String resourceName) {
        if (resourceName == null) {
            return false;
        }
        return resourceName.startsWith(CLASSPATH_RESOURCE_PREFIX) || resourceName.startsWith(FILE_RESOURCE_PREFIX);
    }

    public ITestResource resolve(String resourceName) {
        Validate.notNull((Object)resourceName, (String)"Resource name cannot be null");
        if (!this.hasPrefix(resourceName)) {
            throw new IllegalArgumentException("Resource name \"" + resourceName + "\" has no recognized prefix, and it has not been declared as relative.");
        }
        if (resourceName.startsWith(CLASSPATH_RESOURCE_PREFIX)) {
            return this.resolveClassPathTestResource(resourceName.substring(CLASSPATH_RESOURCE_PREFIX.length()));
        }
        if (resourceName.startsWith(FILE_RESOURCE_PREFIX)) {
            return this.resolveLocalTestResource(resourceName.substring(FILE_RESOURCE_PREFIX.length()));
        }
        throw new IllegalArgumentException("Resource name \"" + resourceName + "\" has no recognized prefix, and it has not been declared as relative.");
    }

    protected ITestResource resolveClassPathTestResource(String resourceName) {
        Validate.notNull((Object)resourceName, (String)"Resource name cannot be null");
        ClassLoader cl = ClassLoaderUtils.getClassLoader(StandardTestResourceResolver.class);
        URL resourceURL = cl.getResource(resourceName);
        if (resourceURL == null) {
            throw new TestEngineExecutionException("Error while reading classpath resource \"" + resourceName + "\". " + "Could not obtain resource as URL.");
        }
        try {
            File resourceFile = new File(resourceURL.toURI());
            if (resourceFile.isDirectory()) {
                return new LocalFolderTestResource(resourceFile, this.characterEncoding);
            }
            return new LocalFileTestResource(resourceFile, this.characterEncoding);
        }
        catch (TestEngineExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            return new ClassPathFileTestResource(resourceName, this.characterEncoding);
        }
    }

    protected ITestResource resolveLocalTestResource(String resourceName) {
        Validate.notNull((Object)resourceName, (String)"Resource name cannot be null");
        try {
            File resourceFile = new File(resourceName);
            if (resourceFile.isDirectory()) {
                return new LocalFolderTestResource(resourceFile, this.characterEncoding);
            }
            return new LocalFileTestResource(resourceFile, this.characterEncoding);
        }
        catch (TestEngineExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestEngineExecutionException("Error while reading file resource \"" + resourceName + "\".", e);
        }
    }

    public ITestResource resolve(String resourceName, ITestResource relativeTo) {
        Validate.notNull((Object)resourceName, (String)"Resource name cannot be null");
        if (this.hasPrefix(resourceName)) {
            return this.resolve(resourceName);
        }
        if (relativeTo == null) {
            throw new IllegalArgumentException("Resource name \"" + resourceName + "\" has no recognized prefix, and the resource it should be relative to was specified as null.");
        }
        if (resourceName.startsWith(CLASSPATH_RESOURCE_PREFIX)) {
            return this.resolveClassPathTestResource(resourceName.substring(CLASSPATH_RESOURCE_PREFIX.length()));
        }
        if (relativeTo instanceof IClassPathTestResource) {
            IClassPathTestResource classPathFileTestResource = (IClassPathTestResource)relativeTo;
            return this.resolveRelativeClassPathTestResource(resourceName, classPathFileTestResource);
        }
        if (relativeTo instanceof ILocalTestResource) {
            ILocalTestResource localFileTestResource = (ILocalTestResource)relativeTo;
            return this.resolveRelativeLocalTestResource(resourceName, localFileTestResource);
        }
        throw new TestEngineExecutionException("Error while resolving relative resource \"" + resourceName + "\". The resource it " + "should be relative to is of an unknown class: " + relativeTo.getClass().getName());
    }

    protected ITestResource resolveRelativeClassPathTestResource(String resourceName, IClassPathTestResource relativeTo) {
        String nameRelativeTo = relativeTo.getName();
        ArrayList<String> originalTokens = new ArrayList<String>(Arrays.asList(StringUtils.split((Object)nameRelativeTo, (String)"/")));
        String[] newTokens = StringUtils.split((Object)resourceName, (String)"/");
        if (!nameRelativeTo.endsWith("/")) {
            originalTokens.remove(originalTokens.size() - 1);
        }
        for (String newToken : newTokens) {
            if (newToken == null || newToken.trim().equals("")) continue;
            if (newToken.equals("..")) {
                originalTokens.remove(originalTokens.size() - 1);
                continue;
            }
            originalTokens.add(newToken);
        }
        return this.resolveClassPathTestResource(StringUtils.join(originalTokens, (String)"/"));
    }

    protected ITestResource resolveRelativeLocalTestResource(String resourceName, ILocalTestResource relativeTo) {
        File fileRelativeTo = relativeTo.getResourceFile();
        String[] newTokens = StringUtils.split((Object)resourceName, (String)"/");
        File file = fileRelativeTo.getAbsoluteFile();
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        for (String newToken : newTokens) {
            if (newToken == null || newToken.trim().equals("")) continue;
            if (newToken.equals("..")) {
                file = file.getParentFile();
                continue;
            }
            boolean resolved = false;
            for (File containedFile : file.listFiles()) {
                if (!newToken.equals(containedFile.getName())) continue;
                file = containedFile;
                resolved = true;
                break;
            }
            if (resolved) continue;
            throw new TestEngineExecutionException("Error while resolving relative resource \"" + resourceName + "\" relative to " + "\"" + relativeTo.getName() + "\". File does not exist.");
        }
        if (file.isDirectory()) {
            return new LocalFolderTestResource(file, this.characterEncoding);
        }
        return new LocalFileTestResource(file, this.characterEncoding);
    }
}

