/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.util;

import java.util.ArrayList;
import java.util.List;
import org.attoparser.AttoParseException;
import org.attoparser.IAttoHandler;
import org.attoparser.markup.MarkupAttoParser;
import org.attoparser.markup.html.trace.TracingDetailedHtmlAttoHandler;
import org.attoparser.markup.trace.TraceEvent;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultCompareUtils {
    private static final MarkupAttoParser parser = new MarkupAttoParser();

    public static ResultComparison compareResults(String expected, String actual, boolean lenient) {
        Validate.notNull((Object)expected, (String)"Expected result cannot be null");
        Validate.notNull((Object)actual, (String)"Actual result cannot be null");
        TracingDetailedHtmlAttoHandler expectedHandler = new TracingDetailedHtmlAttoHandler();
        TracingDetailedHtmlAttoHandler actualHandler = new TracingDetailedHtmlAttoHandler();
        try {
            parser.parse(expected, (IAttoHandler)expectedHandler);
            parser.parse(actual, (IAttoHandler)actualHandler);
        }
        catch (AttoParseException e) {
            throw new TestEngineExecutionException("Error while trying to compare results", e);
        }
        List<TraceEvent> expectedTrace = lenient ? ResultCompareUtils.normalizeTrace(expectedHandler.getTrace()) : expectedHandler.getTrace();
        List<TraceEvent> actualTrace = lenient ? ResultCompareUtils.normalizeTrace(actualHandler.getTrace()) : actualHandler.getTrace();
        int actualTraceSize = actualTrace.size();
        int expectedTraceSize = expectedTrace.size();
        for (int i = 0; i < actualTraceSize; ++i) {
            boolean itemMatches;
            TraceEvent expectedTraceItem;
            TraceEvent actualTraceItem = actualTrace.get(i);
            TraceEvent traceEvent = expectedTraceItem = expectedTraceSize > i ? expectedTrace.get(i) : null;
            if (expectedTraceItem == null) {
                String actualFragment = ResultCompareUtils.getFragmentSurrounding(actual, actualTraceItem.getLine(), actualTraceItem.getCol(), 20, 80);
                String expectedFragment = ResultCompareUtils.getFragmentSurrounding(expected, Integer.MAX_VALUE, Integer.MAX_VALUE, 20, 0);
                String explanation = ResultCompareUtils.createExplanation(actualFragment, actualTraceItem.getLine(), actualTraceItem.getCol(), expectedFragment);
                return new ResultComparison(false, explanation);
            }
            boolean bl = itemMatches = lenient ? actualTraceItem.matchesTypeAndContent(expectedTraceItem) : actualTraceItem.equals((Object)expectedTraceItem);
            if (itemMatches) continue;
            String actualFragment = ResultCompareUtils.getFragmentSurrounding(actual, actualTraceItem.getLine(), actualTraceItem.getCol(), 20, 80);
            String expectedFragment = ResultCompareUtils.getFragmentSurrounding(expected, expectedTraceItem.getLine(), expectedTraceItem.getCol(), 20, 80);
            String explanation = ResultCompareUtils.createExplanation(actualFragment, actualTraceItem.getLine(), actualTraceItem.getCol(), expectedFragment);
            return new ResultComparison(false, explanation);
        }
        return new ResultComparison(true, "OK");
    }

    private static List<TraceEvent> normalizeTrace(List<TraceEvent> trace) {
        TraceEvent lastWhitespaceEvent = null;
        ArrayList<TraceEvent> newTrace = new ArrayList<TraceEvent>();
        for (TraceEvent event : trace) {
            String text;
            String eventType = event.getType();
            if ("T".equals(eventType)) {
                text = event.getContent()[0];
                newTrace.add(new TraceEvent(event.getLine(), event.getCol(), "T", new String[]{ResultCompareUtils.compressWhitespace(text)}));
                continue;
            }
            if ("IW".equals(eventType)) {
                text = event.getContent()[0];
                lastWhitespaceEvent = new TraceEvent(event.getLine(), event.getCol(), "IW", new String[]{ResultCompareUtils.compressWhitespace(text)});
                continue;
            }
            if ("A".equals(eventType)) {
                if (lastWhitespaceEvent != null) {
                    newTrace.add(lastWhitespaceEvent);
                    lastWhitespaceEvent = null;
                }
                newTrace.add(event);
                continue;
            }
            newTrace.add(event);
        }
        return newTrace;
    }

    private static String compressWhitespace(String text) {
        StringBuilder strBuilder = new StringBuilder();
        boolean whitespace = false;
        int textLen = text.length();
        for (int i = 0; i < textLen; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                if (whitespace) continue;
                strBuilder.append(' ');
                whitespace = true;
                continue;
            }
            whitespace = false;
            strBuilder.append(c);
        }
        return strBuilder.toString();
    }

    private static String getFragmentSurrounding(String text, int line, int col, int before, int after) {
        int pos;
        int textLen = text.length();
        int cline = 1;
        int ccol = 1;
        for (pos = 0; pos < textLen && (cline < line || ccol < col); ++pos) {
            char c = text.charAt(pos);
            if (c == '\n') {
                ++cline;
                ccol = 1;
                continue;
            }
            ++ccol;
        }
        if (pos >= textLen) {
            pos = textLen - 1;
        }
        int startPos = Math.max(0, pos - before);
        int endPos = Math.min(textLen, pos + after);
        return new String(text.substring(startPos, endPos));
    }

    public static String createExplanation(String actualFragment, int actualLine, int actualCol, String expectedFragment) {
        return "Actual result does not match expected result. Obtained: [" + actualFragment + "] " + "at line " + actualLine + " col " + actualCol + ", but " + "expected [" + expectedFragment + "]";
    }

    private ResultCompareUtils() {
    }

    public static void main(String[] args) {
        String m1 = "<!DOCTYPE html>\n<html>\n  <head class=\"a\" th:include=\"header\">\n  </head>\n  <body>\n      <h1 th:utext=\"${onevar}\">Hello!</h1>\n  </body>\n</html>";
        System.out.println("[" + ResultCompareUtils.getFragmentSurrounding("<!DOCTYPE html>\n<html>\n  <head class=\"a\" th:include=\"header\">\n  </head>\n  <body>\n      <h1 th:utext=\"${onevar}\">Hello!</h1>\n  </body>\n</html>", 3, 10, 50, 60) + "]");
    }

    public static class ResultComparison {
        private final boolean result;
        private final String explanation;

        public ResultComparison(boolean result, String explanation) {
            this.result = result;
            this.explanation = explanation;
        }

        public boolean getResult() {
            return this.result;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }
}

