/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.testable;

import org.thymeleaf.testing.templateengine.testable.ITestResult;
import org.thymeleaf.util.Validate;

public class TestResult
implements ITestResult {
    private final String testName;
    private final boolean ok;
    private final String message;
    private final Throwable throwable;

    public static TestResult ok(String testName) {
        return new TestResult(testName, true, null, null);
    }

    public static TestResult ok(String testName, String message) {
        Validate.notEmpty((String)message, (String)"Message cannot be null or empty");
        return new TestResult(testName, true, message, null);
    }

    public static TestResult ok(String testName, Throwable t) {
        Validate.notNull((Object)t, (String)"Throwable cannot be null");
        return new TestResult(testName, true, null, t);
    }

    public static TestResult ok(String testName, String message, Throwable t) {
        Validate.notEmpty((String)message, (String)"Message cannot be null or empty");
        Validate.notNull((Object)t, (String)"Throwable cannot be null");
        return new TestResult(testName, true, message, t);
    }

    public static TestResult error(String testName, String message) {
        Validate.notEmpty((String)message, (String)"Message cannot be null or empty");
        return new TestResult(testName, false, message, null);
    }

    public static TestResult error(String testName, String message, Throwable t) {
        Validate.notEmpty((String)message, (String)"Message cannot be null or empty");
        Validate.notNull((Object)t, (String)"Throwable cannot be null");
        return new TestResult(testName, false, message, t);
    }

    public static TestResult error(String testName, Throwable t) {
        Validate.notNull((Object)t, (String)"Throwable cannot be null");
        return new TestResult(testName, false, t.getMessage(), t);
    }

    protected TestResult(String testName, boolean ok, String message, Throwable throwable) {
        Validate.notNull((Object)testName, (String)"Test name cannot be null. Remember this must be the context-registered name.");
        this.testName = testName;
        this.ok = ok;
        this.message = message;
        this.throwable = throwable;
    }

    public String getTestName() {
        return this.testName;
    }

    public boolean isOK() {
        return this.ok;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean hasThrowable() {
        return this.throwable != null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

