/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestRawData;
import org.thymeleaf.testing.templateengine.standard.test.reader.IStandardTestReader;
import org.thymeleaf.util.Validate;

public class StandardTestReader
implements IStandardTestReader {
    public static final char COMMENT_PREFIX_CHAR = '#';
    public static final char FIELD_PREFIX_CHAR = '%';
    public static final Pattern FIELD_DEFINITION_PATTERN = Pattern.compile("([\\p{Alnum}_-]*)(\\[(\\S*)\\])?");
    public static final int FIELD_NAME_GROUP = 1;
    public static final int FIELD_QUALIFIER_GROUP = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardTestRawData readTestDocument(String executionId, String documentName, Reader documentReader) throws IOException {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)documentName, (String)"Document name cannot be null");
        Validate.notNull((Object)documentReader, (String)"Document reader cannot be null");
        BufferedReader r = new BufferedReader(documentReader);
        StandardTestRawData data = new StandardTestRawData(documentName);
        try {
            String currentFieldName = null;
            String currentFieldQualifier = null;
            StringBuilder strBuilder = null;
            String line = r.readLine();
            while (line != null) {
                if (this.isCommentLine(line)) {
                    line = r.readLine();
                    continue;
                }
                String newFieldDefinition = StandardTestReader.extractFieldDefinition(line);
                if (newFieldDefinition == null) {
                    if (currentFieldName == null) {
                        line = r.readLine();
                        continue;
                    }
                    if (strBuilder != null) {
                        if (strBuilder.length() > 0) {
                            strBuilder.append('\n');
                        }
                        strBuilder.append(line);
                    }
                    line = r.readLine();
                    continue;
                }
                if (currentFieldName != null && strBuilder != null) {
                    data.setValue(currentFieldName, currentFieldQualifier, strBuilder.toString());
                }
                int lineLen = line.length();
                currentFieldName = StandardTestReader.extractFieldName(newFieldDefinition);
                currentFieldQualifier = StandardTestReader.extractFieldQualifier(newFieldDefinition);
                strBuilder = new StringBuilder();
                if (newFieldDefinition.length() + 1 < lineLen - 1) {
                    int valueStart;
                    for (valueStart = newFieldDefinition.length() + 1; valueStart < lineLen && Character.isWhitespace(line.charAt(valueStart)); ++valueStart) {
                    }
                    if (valueStart < lineLen - 1) {
                        strBuilder.append(line.substring(valueStart));
                    }
                }
                line = r.readLine();
            }
            if (currentFieldName != null && strBuilder != null) {
                data.setValue(currentFieldName, currentFieldQualifier, strBuilder.toString());
            }
        }
        finally {
            try {
                r.close();
            }
            catch (Throwable t) {}
        }
        return data;
    }

    protected boolean isCommentLine(String line) {
        return line.length() > 0 && line.charAt(0) == '#';
    }

    private static String extractFieldDefinition(String line) {
        int i;
        int lineLen = line.length();
        if (lineLen <= 0) {
            return null;
        }
        char c = line.charAt(0);
        if (c != '%') {
            return null;
        }
        for (i = 1; i < lineLen && !Character.isWhitespace(c = line.charAt(i)); ++i) {
        }
        String tentativeFieldDefinition = line.substring(1, i);
        return StandardTestReader.isFieldDefinition(tentativeFieldDefinition) ? tentativeFieldDefinition : null;
    }

    private static boolean isFieldDefinition(String name) {
        if (name == null) {
            return false;
        }
        Matcher m = FIELD_DEFINITION_PATTERN.matcher(name);
        return m.matches();
    }

    private static String extractFieldName(String fieldDefinition) {
        if (fieldDefinition == null) {
            return null;
        }
        Matcher m = FIELD_DEFINITION_PATTERN.matcher(fieldDefinition);
        if (!m.matches()) {
            return null;
        }
        String name = m.group(1);
        if (name == null || name.trim().equals("")) {
            return null;
        }
        return name.trim();
    }

    private static String extractFieldQualifier(String fieldDefinition) {
        if (fieldDefinition == null) {
            return null;
        }
        Matcher m = FIELD_DEFINITION_PATTERN.matcher(fieldDefinition);
        if (!m.matches()) {
            return null;
        }
        String qualifier = m.group(3);
        if (qualifier == null || qualifier.trim().equals("")) {
            return null;
        }
        return qualifier.trim();
    }
}

