/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine.resolver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResourceResolver
implements IResourceResolver {
    public static final String NAME = "TEST";
    private final Map<String, ITestResource> resources;
    private final String characterEncoding;

    public TestResourceResolver(Map<String, ITestResource> resources, String characterEncoding) {
        Validate.notNull(resources, (String)"Resources map cannot be null");
        Validate.notNull((Object)characterEncoding, (String)"Character encoding cannot be null");
        this.resources = Collections.unmodifiableMap(new HashMap<String, ITestResource>(resources));
        this.characterEncoding = characterEncoding;
    }

    public String getName() {
        return NAME;
    }

    public Map<String, ITestResource> getTestResources() {
        return this.resources;
    }

    public ITestResource getTestResource(String resourceName) {
        Validate.notNull((Object)resourceName, (String)"Resource name cannot be null");
        return this.resources.get(resourceName);
    }

    public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
        try {
            ITestResource resource = this.resources.get(resourceName);
            if (resource == null) {
                return null;
            }
            String input = resource.read();
            if (input == null) {
                return null;
            }
            return new ByteArrayInputStream(input.getBytes(this.characterEncoding));
        }
        catch (Exception e) {
            throw new TestEngineExecutionException("Exception resolving test resource \"" + resourceName + "\"");
        }
    }
}

