/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.Validate;

final class TestNamer {
    private final Map<String, ITest> testsByName = new HashMap<String, ITest>();
    private final Map<ITest, String> namesByTest = new HashMap<ITest, String>();
    private final Map<String, Integer> counterByClassName = new HashMap<String, Integer>();

    TestNamer() {
    }

    public synchronized String nameTest(ITest test) {
        Validate.notNull((Object)test, (String)"Test cannot be null");
        if (this.namesByTest.containsKey(test)) {
            return this.namesByTest.get(test);
        }
        if (test.hasName()) {
            String name = test.getName();
            if (this.testsByName.containsKey(name)) {
                throw new TestEngineExecutionException("Duplicate test names: two or more different tests with the same name \"" + name + "\" exist");
            }
            this.testsByName.put(name, test);
            this.namesByTest.put(test, name);
            return name;
        }
        String className = test.getClass().getSimpleName();
        Integer counter = this.counterByClassName.get(className);
        if (counter == null) {
            counter = 1;
        }
        String name = String.format("%s-%05d", className, counter);
        this.counterByClassName.put(className, counter + 1);
        this.testsByName.put(name, test);
        this.namesByTest.put(test, name);
        return name;
    }
}

