/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.expression;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring6.expression.IThymeleafEvaluationContext;

public final class SPELContextPropertyAccessor
implements PropertyAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPELContextPropertyAccessor.class);
    static final SPELContextPropertyAccessor INSTANCE = new SPELContextPropertyAccessor();
    private static final String REQUEST_PARAMETERS_RESTRICTED_VARIABLE_NAME = "param";
    private static final Class<?>[] TARGET_CLASSES = new Class[]{IContext.class};

    SPELContextPropertyAccessor() {
    }

    public Class<?>[] getSpecificTargetClasses() {
        return TARGET_CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        if (context instanceof IThymeleafEvaluationContext && ((IThymeleafEvaluationContext)context).isVariableAccessRestricted() && REQUEST_PARAMETERS_RESTRICTED_VARIABLE_NAME.equals(name)) {
            throw new AccessException("Access to variable \"" + name + "\" is forbidden in this context. Note some restrictions apply to variable access. For example, direct access to request parameters is forbidden in preprocessing and unescaped expressions, in TEXT template mode, in fragment insertion specifications and in some specific attribute processors.");
        }
        return target != null;
    }

    public TypedValue read(EvaluationContext evaluationContext, Object target, String name) throws AccessException {
        if (target == null) {
            throw new AccessException("Cannot read property of null target");
        }
        try {
            Object execInfoResult;
            if ("execInfo".equals(name) && (execInfoResult = SPELContextPropertyAccessor.checkExecInfo(name, evaluationContext)) != null) {
                return new TypedValue(execInfoResult);
            }
            IContext context = (IContext)target;
            return new TypedValue(context.getVariable(name));
        }
        catch (ClassCastException e) {
            throw new AccessException("Cannot read target of class " + target.getClass().getName());
        }
    }

    @Deprecated
    static Object checkExecInfo(String propertyName, EvaluationContext context) {
        if ("execInfo".equals(propertyName)) {
            if (!(context instanceof IThymeleafEvaluationContext)) {
                throw new TemplateProcessingException("Found Thymeleaf Standard Expression containing a call to the context variable \"execInfo\" (e.g. \"${execInfo.templateName}\"), which has been deprecated. The Execution Info should be now accessed as an expression object instead (e.g. \"${#execInfo.templateName}\"). Deprecated use is still allowed (will be removed in future versions of Thymeleaf) when the SpringEL EvaluationContext implements the " + IThymeleafEvaluationContext.class + " interface, but the current evaluation context of class " + context.getClass().getName() + " DOES NOT implement such interface.");
            }
            LOGGER.warn("[THYMELEAF][{}] Found Thymeleaf Standard Expression containing a call to the context variable \"execInfo\" (e.g. \"${execInfo.templateName}\"), which has been deprecated. The Execution Info should be now accessed as an expression object instead (e.g. \"${#execInfo.templateName}\"). Deprecated use is still allowed, but will be removed in future versions of Thymeleaf.", (Object)TemplateEngine.threadIndex());
            return ((IThymeleafEvaluationContext)context).getExpressionObjects().getObject("execInfo");
        }
        return null;
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new AccessException("Cannot write to " + IContext.class.getName());
    }
}

