/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import java.util.LinkedHashMap;
import java.util.Map;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;
import org.unbescape.html.HtmlEscape;

public final class SpringActionTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int ATTR_PRECEDENCE = 1000;
    public static final String TARGET_ATTR_NAME = "action";
    private static final TemplateMode TEMPLATE_MODE = TemplateMode.HTML;
    private static final String METHOD_ATTR_NAME = "method";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String NAME_ATTR_NAME = "name";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String METHOD_ATTR_DEFAULT_VALUE = "GET";
    private AttributeDefinition targetAttributeDefinition;
    private AttributeDefinition methodAttributeDefinition;

    public SpringActionTagProcessor(String dialectPrefix) {
        super(TEMPLATE_MODE, dialectPrefix, TARGET_ATTR_NAME, 1000, false);
    }

    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull((Object)attributeDefinitions, (String)"Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, TARGET_ATTR_NAME);
        this.methodAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, METHOD_ATTR_NAME);
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        Map<String, String> extraHiddenFields;
        String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? "" : expressionResult.toString()));
        String methodAttributeValue = tag.getAttributeValue(this.methodAttributeDefinition.getAttributeName());
        String httpMethod = methodAttributeValue == null ? METHOD_ATTR_DEFAULT_VALUE : methodAttributeValue;
        newAttributeValue = RequestDataValueProcessorUtils.processAction(context, newAttributeValue, httpMethod);
        StandardProcessorUtils.replaceAttribute((IElementTagStructureHandler)structureHandler, (AttributeName)attributeName, (AttributeDefinition)this.targetAttributeDefinition, (String)TARGET_ATTR_NAME, (String)(newAttributeValue == null ? "" : newAttributeValue));
        if ("form".equalsIgnoreCase(tag.getElementCompleteName()) && (extraHiddenFields = RequestDataValueProcessorUtils.getExtraHiddenFields(context)) != null && extraHiddenFields.size() > 0) {
            IModelFactory modelFactory = context.getModelFactory();
            IModel extraHiddenElementTags = modelFactory.createModel();
            for (Map.Entry<String, String> extraHiddenField : extraHiddenFields.entrySet()) {
                LinkedHashMap<String, String> extraHiddenAttributes = new LinkedHashMap<String, String>(4, 1.0f);
                extraHiddenAttributes.put(TYPE_ATTR_NAME, "hidden");
                extraHiddenAttributes.put(NAME_ATTR_NAME, extraHiddenField.getKey());
                extraHiddenAttributes.put(VALUE_ATTR_NAME, extraHiddenField.getValue());
                IStandaloneElementTag extraHiddenElementTag = modelFactory.createStandaloneElementTag("input", extraHiddenAttributes, AttributeValueQuotes.DOUBLE, false, true);
                extraHiddenElementTags.add((ITemplateEvent)extraHiddenElementTag);
            }
            structureHandler.insertImmediatelyAfter(extraHiddenElementTags, false);
        }
    }
}

