/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.thymeleaf.model.IElementAttributes;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;
import org.unbescape.html.HtmlEscape;

public final class SpringValueTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int ATTR_PRECEDENCE = 1010;
    public static final String TARGET_ATTR_NAME = "value";
    private static final TemplateMode TEMPLATE_MODE = TemplateMode.HTML;
    private static final String TYPE_ATTR_NAME = "type";
    private static final String NAME_ATTR_NAME = "name";
    private AttributeDefinition targetAttributeDefinition;
    private AttributeDefinition fieldAttributeDefinition;
    private AttributeDefinition typeAttributeDefinition;
    private AttributeDefinition nameAttributeDefinition;

    public SpringValueTagProcessor(String dialectPrefix) {
        super(TEMPLATE_MODE, dialectPrefix, TARGET_ATTR_NAME, 1010, false);
    }

    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull((Object)attributeDefinitions, (String)"Attribute Definitions cannot be null");
        String dialectPrefix = this.getMatchingAttributeName().getMatchingAttributeName().getPrefix();
        this.targetAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, TARGET_ATTR_NAME);
        this.fieldAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, dialectPrefix, "field");
        this.typeAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, TYPE_ATTR_NAME);
        this.nameAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, NAME_ATTR_NAME);
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? "" : expressionResult.toString()));
        IElementAttributes attributes = tag.getAttributes();
        if (!attributes.hasAttribute(this.fieldAttributeDefinition.getAttributeName())) {
            String nameValue = attributes.getValue(this.nameAttributeDefinition.getAttributeName());
            String typeValue = attributes.getValue(this.typeAttributeDefinition.getAttributeName());
            newAttributeValue = RequestDataValueProcessorUtils.processFormFieldValue(context, nameValue, newAttributeValue, typeValue);
        }
        StandardProcessorUtils.replaceAttribute((IElementAttributes)attributes, (AttributeName)attributeName, (AttributeDefinition)this.targetAttributeDefinition, (String)TARGET_ATTR_NAME, (String)(newAttributeValue == null ? "" : newAttributeValue));
    }
}

