/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparatorWrapper;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IElementAttributes;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.unbescape.html.HtmlEscape;

public final class SpringInputCheckboxFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public static final String CHECKBOX_INPUT_TYPE_ATTR_VALUE = "checkbox";

    public SpringInputCheckboxFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "input", "type", new String[]{CHECKBOX_INPUT_TYPE_ATTR_VALUE}, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, BindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(context, tag, name, true);
        String value = null;
        boolean checked = false;
        Object boundValue = bindStatus.getValue();
        Class valueType = bindStatus.getValueType();
        IElementAttributes attributes = tag.getAttributes();
        if (Boolean.class.equals((Object)valueType) || Boolean.TYPE.equals(valueType)) {
            if (boundValue instanceof String) {
                boundValue = Boolean.valueOf((String)boundValue);
            }
            Boolean booleanValue = boundValue != null ? (Boolean)boundValue : Boolean.FALSE;
            value = "true";
            checked = booleanValue;
        } else {
            value = attributes.getValue(this.valueAttributeDefinition.getAttributeName());
            if (value == null) {
                throw new TemplateProcessingException("Attribute \"value\" is required in \"input(checkbox)\" tags when binding to non-boolean values");
            }
            checked = SelectedValueComparatorWrapper.isSelected(bindStatus, HtmlEscape.unescapeHtml((String)value));
        }
        StandardProcessorUtils.setAttribute((IElementAttributes)attributes, (AttributeDefinition)this.idAttributeDefinition, (String)"id", (String)id);
        StandardProcessorUtils.setAttribute((IElementAttributes)attributes, (AttributeDefinition)this.nameAttributeDefinition, (String)"name", (String)name);
        StandardProcessorUtils.setAttribute((IElementAttributes)attributes, (AttributeDefinition)this.valueAttributeDefinition, (String)"value", (String)RequestDataValueProcessorUtils.processFormFieldValue(context, name, value, CHECKBOX_INPUT_TYPE_ATTR_VALUE));
        if (checked) {
            StandardProcessorUtils.setAttribute((IElementAttributes)attributes, (AttributeDefinition)this.checkedAttributeDefinition, (String)"checked", (String)"checked");
        } else {
            attributes.removeAttribute(this.checkedAttributeDefinition.getAttributeName());
        }
        if (!this.isDisabled(tag)) {
            IModelFactory modelFactory = context.getConfiguration().getModelFactory(context.getTemplateMode());
            IModel hiddenTagModel = modelFactory.createModel();
            String hiddenName = "_" + name;
            String hiddenValue = "on";
            IStandaloneElementTag hiddenTag = modelFactory.createStandaloneElementTag("input", true);
            IElementAttributes hiddenTagAttributes = hiddenTag.getAttributes();
            StandardProcessorUtils.setAttribute((IElementAttributes)hiddenTagAttributes, (AttributeDefinition)this.typeAttributeDefinition, (String)"type", (String)"hidden");
            StandardProcessorUtils.setAttribute((IElementAttributes)hiddenTagAttributes, (AttributeDefinition)this.nameAttributeDefinition, (String)"name", (String)hiddenName);
            StandardProcessorUtils.setAttribute((IElementAttributes)hiddenTagAttributes, (AttributeDefinition)this.valueAttributeDefinition, (String)"value", (String)RequestDataValueProcessorUtils.processFormFieldValue(context, hiddenName, "on", "hidden"));
            hiddenTagModel.add((ITemplateEvent)hiddenTag);
            structureHandler.insertImmediatelyAfter(hiddenTagModel, false);
        }
    }

    private final boolean isDisabled(IProcessableElementTag tag) {
        return tag.getAttributes().hasAttribute(this.disabledAttributeDefinition.getAttributeName());
    }
}

