/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.springframework.web.servlet.support.BindStatus;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ITemplateProcessingContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IElementStructureHandler;
import org.thymeleaf.engine.IMarkup;
import org.thymeleaf.engine.ITemplateHandlerEvent;
import org.thymeleaf.engine.Markup;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.spring4.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;

public final class SpringSelectFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    static final String OPTION_IN_SELECT_ATTR_NAME = "%%OPTION_IN_SELECT_ATTR_NAME%%";
    static final String OPTION_IN_SELECT_ATTR_VALUE = "%%OPTION_IN_SELECT_ATTR_VALUE%%";

    public SpringSelectFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "select", null, null);
    }

    protected void doProcess(ITemplateProcessingContext processingContext, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, BindStatus bindStatus, IElementStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(processingContext, tag, name, false);
        boolean multiple = tag.getAttributes().hasAttribute("multiple");
        tag.getAttributes().setAttribute("id", id);
        tag.getAttributes().setAttribute("name", name);
        structureHandler.setLocalVariable(OPTION_IN_SELECT_ATTR_NAME, (Object)attributeName);
        structureHandler.setLocalVariable(OPTION_IN_SELECT_ATTR_VALUE, (Object)attributeValue);
        tag.getAttributes().removeAttribute(attributeName);
        if (multiple && !SpringSelectFieldTagProcessor.isDisabled(tag)) {
            Markup hiddenMethodElementMarkup = processingContext.getMarkupFactory().createMarkup();
            String hiddenName = "_" + name;
            String type = "hidden";
            String value = RequestDataValueProcessorUtils.processFormFieldValue((IProcessingContext)processingContext, hiddenName, "1", "hidden");
            IStandaloneElementTag hiddenMethodElementTag = processingContext.getMarkupFactory().createStandaloneElementTag("input", true);
            hiddenMethodElementTag.getAttributes().setAttribute("type", "hidden");
            hiddenMethodElementTag.getAttributes().setAttribute("name", hiddenName);
            hiddenMethodElementTag.getAttributes().setAttribute("value", value);
            hiddenMethodElementMarkup.add((ITemplateHandlerEvent)hiddenMethodElementTag);
            structureHandler.insertBefore((IMarkup)hiddenMethodElementMarkup);
        }
    }

    private static final boolean isDisabled(IProcessableElementTag tag) {
        return tag.getAttributes().hasAttribute("disabled");
    }
}

