/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparatorWrapper;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ITemplateProcessingContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IElementStructureHandler;
import org.thymeleaf.engine.IMarkup;
import org.thymeleaf.engine.ITemplateHandlerEvent;
import org.thymeleaf.engine.Markup;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.spring4.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.unbescape.html.HtmlEscape;

public final class SpringInputCheckboxFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public static final String CHECKBOX_INPUT_TYPE_ATTR_VALUE = "checkbox";

    public SpringInputCheckboxFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "input", "type", new String[]{CHECKBOX_INPUT_TYPE_ATTR_VALUE});
    }

    protected void doProcess(ITemplateProcessingContext processingContext, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, BindStatus bindStatus, IElementStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(processingContext, tag, name, true);
        String value = null;
        boolean checked = false;
        Object boundValue = bindStatus.getValue();
        Class valueType = bindStatus.getValueType();
        if (Boolean.class.equals((Object)valueType) || Boolean.TYPE.equals(valueType)) {
            if (boundValue instanceof String) {
                boundValue = Boolean.valueOf((String)boundValue);
            }
            Boolean booleanValue = boundValue != null ? (Boolean)boundValue : Boolean.FALSE;
            value = "true";
            checked = booleanValue;
        } else {
            value = tag.getAttributes().getValue("value");
            if (value == null) {
                throw new TemplateProcessingException("Attribute \"value\" is required in \"input(checkbox)\" tags when binding to non-boolean values");
            }
            checked = SelectedValueComparatorWrapper.isSelected(bindStatus, HtmlEscape.unescapeHtml((String)value));
        }
        tag.getAttributes().setAttribute("id", id);
        tag.getAttributes().setAttribute("name", name);
        tag.getAttributes().setAttribute("value", RequestDataValueProcessorUtils.processFormFieldValue((IProcessingContext)processingContext, name, value, CHECKBOX_INPUT_TYPE_ATTR_VALUE));
        if (checked) {
            tag.getAttributes().setAttribute("checked", "checked");
        } else {
            tag.getAttributes().removeAttribute("checked");
        }
        tag.getAttributes().removeAttribute(attributeName);
        if (!SpringInputCheckboxFieldTagProcessor.isDisabled(tag)) {
            Markup hiddenTagMarkup = processingContext.getMarkupFactory().createMarkup();
            String hiddenName = "_" + name;
            String hiddenValue = "on";
            IStandaloneElementTag hiddenTag = processingContext.getMarkupFactory().createStandaloneElementTag("input", true);
            hiddenTag.getAttributes().setAttribute("type", "hidden");
            hiddenTag.getAttributes().setAttribute("name", hiddenName);
            hiddenTag.getAttributes().setAttribute("value", RequestDataValueProcessorUtils.processFormFieldValue((IProcessingContext)processingContext, hiddenName, "on", "hidden"));
            hiddenTagMarkup.add((ITemplateHandlerEvent)hiddenTag);
            structureHandler.insertAfter((IMarkup)hiddenTagMarkup, false);
        }
    }

    private static final boolean isDisabled(IProcessableElementTag tag) {
        return tag.getAttributes().hasAttribute("disabled");
    }
}

