/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.thymeleaf.context.VariablesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariablesMapPropertyAccessor
extends ReflectivePropertyAccessor {
    private static final Class<?>[] TARGET_CLASSES = new Class[]{VariablesMap.class};
    public static final VariablesMapPropertyAccessor INSTANCE = new VariablesMapPropertyAccessor();

    public Class<?>[] getSpecificTargetClasses() {
        return TARGET_CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return target != null;
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        if (target == null) {
            throw new AccessException("Cannot read property of null target");
        }
        if (!(target instanceof VariablesMap)) {
            throw new AccessException("Cannot read target of class " + target.getClass().getName());
        }
        return new TypedValue(((VariablesMap)target).get((Object)name));
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return target != null;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        if (target == null) {
            throw new AccessException("Cannot write property of null target");
        }
        if (!(target instanceof VariablesMap)) {
            throw new AccessException("Cannot write target of class " + target.getClass().getName());
        }
        ((VariablesMap)target).put((Object)name, newValue);
    }
}

