/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.util;

import java.util.Arrays;
import java.util.List;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;
import org.thymeleaf.standard.expression.VariableExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldUtils {
    public static final String ALL_FIELDS = "*";
    public static final String ALL_FIELDS_FIELD_EXPRESSION = "*{*}";

    public static boolean hasErrors(Arguments arguments, String field) {
        return FieldUtils.hasErrors(arguments.getConfiguration(), (IProcessingContext)arguments, field);
    }

    public static boolean hasErrors(Configuration configuration, IProcessingContext processingContext, String field) {
        BindStatus bindStatus = FieldUtils.getBindStatus(configuration, processingContext, FieldUtils.convertToFieldExpression(field), true);
        return bindStatus.isError();
    }

    public static List<String> errors(Arguments arguments, String field) {
        return FieldUtils.errors(arguments.getConfiguration(), (IProcessingContext)arguments, field);
    }

    public static List<String> errors(Configuration configuration, IProcessingContext processingContext, String field) {
        BindStatus bindStatus = FieldUtils.getBindStatus(configuration, processingContext, FieldUtils.convertToFieldExpression(field), true);
        String[] errorCodes = bindStatus.getErrorMessages();
        return Arrays.asList(errorCodes);
    }

    public static String idFromName(String fieldName) {
        return StringUtils.deleteAny((String)fieldName, (String)"[]");
    }

    private static String convertToFieldExpression(String field) {
        StringBuilder strBuilder = new StringBuilder(20);
        strBuilder.append('*');
        strBuilder.append('{');
        strBuilder.append(field);
        strBuilder.append('}');
        return strBuilder.toString();
    }

    public static BindStatus getBindStatus(Arguments arguments, String fieldExpression, boolean allowAllFields) {
        return FieldUtils.getBindStatus(arguments.getConfiguration(), (IProcessingContext)arguments, fieldExpression, allowAllFields);
    }

    public static BindStatus getBindStatus(Configuration configuration, IProcessingContext processingContext, String fieldExpression, boolean allowAllFields) {
        RequestContext requestContext = (RequestContext)processingContext.getContext().getVariables().get((Object)"springRequestContext");
        if (requestContext == null) {
            throw new TemplateProcessingException("A request context has not been created");
        }
        if (allowAllFields && ALL_FIELDS_FIELD_EXPRESSION.equals(fieldExpression)) {
            String completeExpression = FieldUtils.validateAndGetValueExpressionForAllFields(processingContext);
            return new BindStatus(requestContext, completeExpression, false);
        }
        Expression expression = StandardExpressionProcessor.parseExpression((Configuration)configuration, (IProcessingContext)processingContext, (String)fieldExpression);
        String completeExpression = FieldUtils.validateAndGetValueExpressionForField(processingContext, expression);
        return new BindStatus(requestContext, completeExpression, false);
    }

    private static String validateAndGetValueExpressionForField(IProcessingContext processingContext, Expression expression) {
        if (expression instanceof SelectionVariableExpression) {
            VariableExpression formCommandValue = (VariableExpression)processingContext.getLocalVariable("springFormCommandValue");
            if (formCommandValue == null) {
                throw new TemplateProcessingException("Cannot process field expression " + expression + " as no form model object has " + "been established in the \"form\" tag");
            }
            String formCommandExpression = formCommandValue.getExpression();
            return formCommandExpression + '.' + ((SelectionVariableExpression)expression).getExpression();
        }
        throw new TemplateProcessingException("Expression \"" + expression + "\" is not valid: only selection variable expressions " + "*{...} are allowed in field specifications");
    }

    private static String validateAndGetValueExpressionForAllFields(IProcessingContext processingContext) {
        VariableExpression formCommandValue = (VariableExpression)processingContext.getLocalVariable("springFormCommandValue");
        if (formCommandValue == null) {
            throw new TemplateProcessingException("Cannot process expression for all fields \"*\" as no form model object has been established in the \"form\" tag");
        }
        String formCommandExpression = formCommandValue.getExpression();
        return formCommandExpression + '.' + ALL_FIELDS;
    }

    private FieldUtils() {
    }
}

