/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.processor.attr;

import java.util.HashMap;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.ValueFormatterWrapper;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Macro;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.spring3.util.FieldUtils;
import org.unbescape.html.HtmlEscape;

public final class SpringErrorsAttrProcessor
extends AbstractAttrProcessor {
    private static final String ERROR_DELIMITER = "<br />";
    public static final int ATTR_PRECEDENCE = 1200;
    public static final String ATTR_NAME = "errors";

    public SpringErrorsAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 1200;
    }

    public ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        BindStatus bindStatus = FieldUtils.getBindStatus(arguments.getConfiguration(), (IProcessingContext)arguments, attributeValue);
        if (bindStatus.isError()) {
            HashMap<String, BindStatus> localVariables = new HashMap<String, BindStatus>(2, 1.0f);
            localVariables.put("springFieldBindStatus", bindStatus);
            StringBuilder strBuilder = new StringBuilder();
            String[] errorMsgs = bindStatus.getErrorMessages();
            for (int i = 0; i < errorMsgs.length; ++i) {
                if (i > 0) {
                    strBuilder.append(ERROR_DELIMITER);
                }
                String displayString = ValueFormatterWrapper.getDisplayString(errorMsgs[i], false);
                strBuilder.append(HtmlEscape.escapeHtml4Xml((String)displayString));
            }
            element.clearChildren();
            Macro errorsNode = new Macro(strBuilder.toString());
            errorsNode.setProcessable(false);
            element.addChild((Node)errorsNode);
            element.removeAttribute(attributeName);
            return ProcessorResult.setLocalVariables(localVariables);
        }
        element.getParent().removeChild((Node)element);
        return ProcessorResult.OK;
    }
}

