/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity3.dialect;

import java.util.LinkedHashSet;
import java.util.Set;
import org.thymeleaf.dialect.AbstractDialect;
import org.thymeleaf.dialect.IExpressionObjectDialect;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.extras.springsecurity3.dialect.expression.SpringSecurityExpressionObjectFactory;
import org.thymeleaf.extras.springsecurity3.dialect.processor.AuthenticationAttrProcessor;
import org.thymeleaf.extras.springsecurity3.dialect.processor.AuthorizeAclAttrProcessor;
import org.thymeleaf.extras.springsecurity3.dialect.processor.AuthorizeAttrProcessor;
import org.thymeleaf.extras.springsecurity3.dialect.processor.AuthorizeUrlAttrProcessor;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.standard.processor.StandardXmlNsTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

public class SpringSecurityDialect
extends AbstractDialect
implements IProcessorDialect,
IExpressionObjectDialect {
    public static final String NAME = "SpringSecurity";
    public static final String DEFAULT_PREFIX = "sec";
    public static final int PROCESSOR_PRECEDENCE = 800;
    public static final IExpressionObjectFactory EXPRESSION_OBJECT_FACTORY = new SpringSecurityExpressionObjectFactory();

    public SpringSecurityDialect() {
        super(NAME);
    }

    public String getPrefix() {
        return DEFAULT_PREFIX;
    }

    public int getDialectProcessorPrecedence() {
        return 800;
    }

    public Set<IProcessor> getProcessors(String dialectPrefix) {
        LinkedHashSet<IProcessor> processors = new LinkedHashSet<IProcessor>();
        processors.add((IProcessor)new AuthenticationAttrProcessor(dialectPrefix));
        processors.add((IProcessor)new AuthorizeAttrProcessor(dialectPrefix, "authorize"));
        processors.add((IProcessor)new AuthorizeAttrProcessor(dialectPrefix, "authorize-expr"));
        processors.add((IProcessor)new AuthorizeUrlAttrProcessor(dialectPrefix));
        processors.add((IProcessor)new AuthorizeAclAttrProcessor(dialectPrefix));
        processors.add((IProcessor)new StandardXmlNsTagProcessor(TemplateMode.HTML, dialectPrefix));
        return processors;
    }

    public IExpressionObjectFactory getExpressionObjectFactory() {
        return EXPRESSION_OBJECT_FACTORY;
    }
}

