/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.conditionalcomments.parser;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.attoparser.AttoParseException;
import org.attoparser.IAttoHandler;
import org.attoparser.markup.MarkupAttoParser;
import org.attoparser.markup.html.AbstractDetailedNonValidatingHtmlAttoHandler;
import org.attoparser.markup.html.HtmlParsing;
import org.attoparser.markup.html.HtmlParsingConfiguration;
import org.attoparser.markup.html.elements.IHtmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.CDATASection;
import org.thymeleaf.dom.Comment;
import org.thymeleaf.dom.DocType;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.templateparser.TemplatePreprocessingReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalCommentAttoTemplateParser
implements ITemplateParser {
    private static final MarkupAttoParser parser = new MarkupAttoParser();
    static final HtmlParsingConfiguration HTML_PARSING_CONFIGURATION = HtmlParsing.htmlParsingConfiguration();

    public final Document parseTemplate(Configuration configuration, String documentName, Reader reader) {
        TemplatePreprocessingReader templateReader = this.getTemplatePreprocessingReader(reader);
        try {
            return ConditionalCommentAttoTemplateParser.doParse(documentName, templateReader);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (AttoParseException e) {
            String message = null;
            message = documentName == null ? String.format("Exception parsing unnamed document or fragment: line %d - column %d", e.getLine(), e.getCol()) : String.format("Exception parsing document: template=\"%s\", line %d - column %d", documentName, e.getLine(), e.getCol());
            throw new TemplateInputException(message, (Throwable)e);
        }
    }

    private static Document doParse(String documentName, TemplatePreprocessingReader reader) throws AttoParseException {
        TemplateAttoHandler handler = new TemplateAttoHandler(documentName);
        parser.parse((Reader)reader, (IAttoHandler)handler);
        String docTypeClause = reader.getDocTypeClause();
        String docTypeRootElementName = handler.getDocTypeRootElementName();
        String docTypePublicId = handler.getDocTypePublicId();
        String docTypeSystemId = handler.getDocTypeSystemId();
        DocType docType = docTypeRootElementName != null ? new DocType(docTypeRootElementName, docTypePublicId, docTypeSystemId, docTypeClause) : null;
        List<Node> rootNodes = handler.getRootNodes();
        String xmlVersion = handler.getXmlVersion();
        String xmlEncoding = handler.getXmlEncoding();
        boolean xmlStandalone = handler.isXmlStandalone();
        Document document = new Document(documentName, docType);
        if (xmlVersion != null) {
            document.setNodeProperty("XML_VERSION", (Object)xmlVersion);
        }
        if (xmlEncoding != null) {
            document.setNodeProperty("XML_ENCODING", (Object)xmlEncoding);
        }
        if (xmlStandalone) {
            document.setNodeProperty("XML_STANDALONE", (Object)Boolean.TRUE);
        }
        document.setChildren(rootNodes);
        return document;
    }

    public final List<Node> parseFragment(Configuration configuration, String fragment) {
        Document document = this.parseTemplate(configuration, null, new StringReader(fragment));
        return document.getChildren();
    }

    public final List<Node> parseFragment(Configuration configuration, String text, int offset, int len) {
        Document document = this.parseTemplate(configuration, null, new StringReader(text.substring(offset, offset + len)));
        return document.getChildren();
    }

    protected boolean shouldAddThymeleafRootToParser() {
        return true;
    }

    protected TemplatePreprocessingReader getTemplatePreprocessingReader(Reader reader) {
        if (reader instanceof TemplatePreprocessingReader) {
            TemplatePreprocessingReader templatePreprocessingReader = (TemplatePreprocessingReader)reader;
            return new TemplatePreprocessingReader(templatePreprocessingReader.getInnerReader(), 8192, this.shouldAddThymeleafRootToParser());
        }
        return new TemplatePreprocessingReader(reader, 8192, this.shouldAddThymeleafRootToParser());
    }

    static {
        HTML_PARSING_CONFIGURATION.setRequireUniqueAttributesInElement(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TemplateAttoHandler
    extends AbstractDetailedNonValidatingHtmlAttoHandler {
        private static final Logger logger = LoggerFactory.getLogger(TemplateAttoHandler.class);
        private final String documentName;
        private final Stack<NestableNode> elementStack;
        private Element currentElement = null;
        private List<Node> rootNodes = null;
        private String docTypeRootElementName = null;
        private String docTypePublicId = null;
        private String docTypeSystemId = null;
        private String xmlEncoding = null;
        private String xmlVersion = null;
        private boolean xmlStandalone = false;

        public TemplateAttoHandler(String documentName) {
            super(HTML_PARSING_CONFIGURATION);
            this.documentName = documentName;
            this.elementStack = new Stack();
            this.rootNodes = new ArrayList<Node>();
        }

        public String getDocTypeRootElementName() {
            return this.docTypeRootElementName;
        }

        public String getDocTypePublicId() {
            return this.docTypePublicId;
        }

        public String getDocTypeSystemId() {
            return this.docTypeSystemId;
        }

        public List<Node> getRootNodes() {
            return this.rootNodes;
        }

        public String getXmlEncoding() {
            return this.xmlEncoding;
        }

        public String getXmlVersion() {
            return this.xmlVersion;
        }

        public boolean isXmlStandalone() {
            return this.xmlStandalone;
        }

        public void handleDocumentEnd(long endTimeNanos, long totalTimeNanos, int line, int col, HtmlParsingConfiguration configuration) throws AttoParseException {
            super.handleDocumentEnd(endTimeNanos, totalTimeNanos, line, col, configuration);
            if (logger.isTraceEnabled()) {
                BigDecimal elapsed = BigDecimal.valueOf(totalTimeNanos);
                BigDecimal elapsedMs = elapsed.divide(BigDecimal.valueOf(1000000L), RoundingMode.HALF_UP);
                if (this.documentName == null) {
                    logger.trace("[THYMELEAF][{}][{}][{}] Parsed unnamed template or fragment in {} nanoseconds (approx. {}ms)", new Object[]{TemplateEngine.threadIndex(), elapsed, elapsedMs, elapsed, elapsedMs});
                } else {
                    logger.trace("[THYMELEAF][{}][{}][{}][{}] Parsed template \"{}\" in {} nanoseconds (approx. {}ms)", new Object[]{TemplateEngine.threadIndex(), this.documentName, elapsed, elapsedMs, this.documentName, elapsed, elapsedMs});
                }
            }
        }

        public void handleXmlDeclarationDetail(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int versionOffset, int versionLen, int versionLine, int versionCol, int encodingOffset, int encodingLen, int encodingLine, int encodingCol, int standaloneOffset, int standaloneLen, int standaloneLine, int standaloneCol, int outerOffset, int outerLen, int line, int col) throws AttoParseException {
            super.handleXmlDeclarationDetail(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, versionOffset, versionLen, versionLine, versionCol, encodingOffset, encodingLen, encodingLine, encodingCol, standaloneOffset, standaloneLen, standaloneLine, standaloneCol, outerOffset, outerLen, line, col);
            if (versionLen > 0) {
                this.xmlVersion = new String(buffer, versionOffset, versionLen);
            }
            if (encodingLen > 0) {
                this.xmlEncoding = new String(buffer, encodingOffset, encodingLen);
            }
            if (standaloneLen > 0) {
                this.xmlStandalone = Boolean.parseBoolean(new String(buffer, standaloneOffset, standaloneLen));
            }
        }

        public void handleDocType(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int elementNameOffset, int elementNameLen, int elementNameLine, int elementNameCol, int typeOffset, int typeLen, int typeLine, int typeCol, int publicIdOffset, int publicIdLen, int publicIdLine, int publicIdCol, int systemIdOffset, int systemIdLen, int systemIdLine, int systemIdCol, int internalSubsetOffset, int internalSubsetLen, int internalSubsetLine, int internalSubsetCol, int outerOffset, int outerLen, int outerLine, int outerCol) throws AttoParseException {
            super.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, publicIdOffset, publicIdLen, publicIdLine, publicIdCol, systemIdOffset, systemIdLen, systemIdLine, systemIdCol, internalSubsetOffset, internalSubsetLen, internalSubsetLine, internalSubsetCol, outerOffset, outerLen, outerLine, outerCol);
            if (elementNameLen > 0) {
                this.docTypeRootElementName = new String(buffer, elementNameOffset, elementNameLen);
            }
            if (publicIdLen > 0) {
                this.docTypePublicId = new String(buffer, publicIdOffset, publicIdLen);
            }
            if (systemIdLen > 0) {
                this.docTypeSystemId = new String(buffer, systemIdOffset, systemIdLen);
            }
        }

        public void handleCDATASection(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws AttoParseException {
            super.handleCDATASection(buffer, contentOffset, contentLen, outerOffset, outerLen, line, col);
            String content = new String(buffer, contentOffset, contentLen);
            TemplatePreprocessingReader.removeEntitySubstitutions((char[])buffer, (int)0, (int)contentLen);
            CDATASection cdata = new CDATASection(content, null, null, true);
            if (this.elementStack.isEmpty()) {
                this.rootNodes.add((Node)cdata);
            } else {
                NestableNode parent = this.elementStack.peek();
                parent.addChild((Node)cdata);
            }
        }

        public void handleText(char[] buffer, int offset, int len, int line, int col) throws AttoParseException {
            super.handleText(buffer, offset, len, line, col);
            TemplatePreprocessingReader.removeEntitySubstitutions((char[])buffer, (int)offset, (int)len);
            String content = new String(buffer, offset, len);
            Text textNode = new Text(content, null, null, true);
            if (this.elementStack.isEmpty()) {
                this.rootNodes.add((Node)textNode);
            } else {
                NestableNode parent = this.elementStack.peek();
                parent.addChild((Node)textNode);
            }
        }

        public void handleComment(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws AttoParseException {
            super.handleComment(buffer, contentOffset, contentLen, outerOffset, outerLen, line, col);
            String content = new String(buffer, contentOffset, contentLen);
            Comment comment = new Comment(content);
            if (this.elementStack.isEmpty()) {
                this.rootNodes.add((Node)comment);
            } else {
                NestableNode parent = this.elementStack.peek();
                parent.addChild((Node)comment);
            }
        }

        public void handleHtmlAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws AttoParseException {
            super.handleHtmlAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, valueLine, valueCol);
            String attributeName = new String(buffer, nameOffset, nameLen);
            TemplatePreprocessingReader.removeEntitySubstitutions((char[])buffer, (int)valueContentOffset, (int)valueContentLen);
            String attributeValue = new String(buffer, valueContentOffset, valueContentLen);
            this.currentElement.setAttribute(attributeName, false, attributeValue, true);
        }

        public void handleHtmlStandaloneElementStart(IHtmlElement htmlElement, boolean minimized, char[] buffer, int offset, int len, int line, int col) throws AttoParseException {
            Element element;
            super.handleHtmlStandaloneElementStart(htmlElement, minimized, buffer, offset, len, line, col);
            String elementName = new String(buffer, offset, len);
            this.currentElement = element = new Element(elementName, this.documentName, Integer.valueOf(line), Element.RepresentationInTemplate.STANDALONE);
            if (this.elementStack.isEmpty()) {
                this.rootNodes.add((Node)element);
            } else {
                NestableNode parent = this.elementStack.peek();
                parent.addChild((Node)element);
            }
        }

        public void handleHtmlOpenElementStart(IHtmlElement htmlElement, char[] buffer, int offset, int len, int line, int col) throws AttoParseException {
            Element element;
            super.handleHtmlOpenElementStart(htmlElement, buffer, offset, len, line, col);
            String elementName = new String(buffer, offset, len);
            this.currentElement = element = new Element(elementName, this.documentName, Integer.valueOf(line), Element.RepresentationInTemplate.ONLY_OPEN);
            this.elementStack.push((NestableNode)element);
        }

        public void handleHtmlCloseElementStart(IHtmlElement htmlElement, char[] buffer, int offset, int len, int line, int col) throws AttoParseException {
            super.handleHtmlCloseElementStart(htmlElement, buffer, offset, len, line, col);
            String closedElementName = new String(buffer, offset, len);
            this.searchInStack(closedElementName);
            NestableNode node = this.elementStack.pop();
            if (node instanceof Element) {
                Element element = (Element)node;
                if (element.hasChildren()) {
                    element.setRepresentationInTemplate(Element.RepresentationInTemplate.OPEN_AND_CLOSE_NONEMPTY);
                } else {
                    element.setRepresentationInTemplate(Element.RepresentationInTemplate.OPEN_AND_CLOSE_EMPTY);
                }
                if ("THYMELEAF_ROOT".equals(element.getOriginalName())) {
                    List syntheticRootChildren = element.getChildren();
                    if (this.elementStack.isEmpty()) {
                        this.rootNodes.addAll(syntheticRootChildren);
                    } else {
                        NestableNode parent = this.elementStack.peek();
                        for (Node syntheticRootChild : syntheticRootChildren) {
                            parent.addChild(syntheticRootChild);
                        }
                    }
                    return;
                }
            }
            if (this.elementStack.isEmpty()) {
                this.rootNodes.add((Node)node);
            } else {
                NestableNode parent = this.elementStack.peek();
                parent.addChild((Node)node);
            }
        }

        private void searchInStack(String soughtElementName) {
            NestableNode node = this.elementStack.peek();
            Element element;
            String elementName;
            while (!(node instanceof Element) || !soughtElementName.equals(elementName = (element = (Element)node).getOriginalName())) {
                NestableNode unbalancedNode = this.elementStack.pop();
                if (this.elementStack.isEmpty()) {
                    throw new TemplateInputException("Unbalanced close tag \"" + soughtElementName + "\"");
                }
                NestableNode parent = this.elementStack.peek();
                parent.addChild((Node)unbalancedNode);
                node = parent;
            }
            return;
        }
    }
}

