/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.toxiproxy;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class ToxiproxyContainer
extends GenericContainer<ToxiproxyContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"shopify/toxiproxy");
    private static final DockerImageName GHCR_IMAGE_NAME = DockerImageName.parse((String)"ghcr.io/shopify/toxiproxy");
    private static final int TOXIPROXY_CONTROL_PORT = 8474;
    private static final int FIRST_PROXIED_PORT = 8666;
    private static final int LAST_PROXIED_PORT = 8697;

    public ToxiproxyContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ToxiproxyContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME, GHCR_IMAGE_NAME});
        this.addExposedPorts(new int[]{8474});
        this.setWaitStrategy((WaitStrategy)new HttpWaitStrategy().forPath("/version").forPort(8474));
        for (int i = 8666; i <= 8697; ++i) {
            this.addExposedPort(i);
        }
    }

    public int getControlPort() {
        return this.getMappedPort(8474);
    }
}

