/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.SolrClientUtils;
import org.testcontainers.containers.SolrContainerConfiguration;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;

public class SolrContainer
extends GenericContainer<SolrContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"solr");
    @Deprecated
    public static final String DEFAULT_TAG = "8.3.0";
    public static final Integer ZOOKEEPER_PORT = 9983;
    public static final Integer SOLR_PORT = 8983;
    private SolrContainerConfiguration configuration;
    private final ComparableVersion imageVersion;

    @Deprecated
    public SolrContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public SolrContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public SolrContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitStrategy = new LogMessageWaitStrategy().withRegEx(".*o\\.e\\.j\\.s\\.Server Started.*").withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
        this.configuration = new SolrContainerConfiguration();
        this.imageVersion = new ComparableVersion(dockerImageName.getVersionPart());
    }

    public SolrContainer withZookeeper(boolean zookeeper) {
        this.configuration.setZookeeper(zookeeper);
        return (SolrContainer)this.self();
    }

    public SolrContainer withCollection(String collection) {
        if (StringUtils.isEmpty((CharSequence)collection)) {
            throw new IllegalArgumentException("Collection name must not be empty");
        }
        this.configuration.setCollectionName(collection);
        return (SolrContainer)this.self();
    }

    public SolrContainer withConfiguration(String name, URL solrConfig) {
        if (StringUtils.isEmpty((CharSequence)name) || solrConfig == null) {
            throw new IllegalArgumentException();
        }
        this.configuration.setConfigurationName(name);
        this.configuration.setSolrConfiguration(solrConfig);
        return (SolrContainer)this.self();
    }

    public SolrContainer withSchema(URL schema) {
        this.configuration.setSolrSchema(schema);
        return (SolrContainer)this.self();
    }

    public int getSolrPort() {
        return this.getMappedPort(SOLR_PORT);
    }

    public int getZookeeperPort() {
        return this.getMappedPort(ZOOKEEPER_PORT);
    }

    protected void configure() {
        if (this.configuration.getSolrSchema() != null && this.configuration.getSolrConfiguration() == null) {
            throw new IllegalStateException("Solr needs to have a configuration if you want to use a schema");
        }
        String command = "solr start -f";
        this.addExposedPort(SOLR_PORT);
        if (this.configuration.isZookeeper()) {
            this.addExposedPort(ZOOKEEPER_PORT);
            command = this.imageVersion.isGreaterThanOrEqualTo("9.7.0") ? "-DzkRun --host localhost" : "-DzkRun -h localhost";
        }
        this.setCommand(command);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return new HashSet<Integer>(this.getSolrPort());
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (!this.configuration.isZookeeper()) {
            Container.ExecResult result = this.execInContainer(new String[]{"solr", "create", "-c", this.configuration.getCollectionName()});
            if (result.getExitCode() != 0) {
                throw new IllegalStateException("Unable to create solr core:\nStdout: " + result.getStdout() + "\nStderr:" + result.getStderr());
            }
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.configuration.getConfigurationName())) {
            SolrClientUtils.uploadConfiguration(this.getHost(), this.getSolrPort(), this.configuration.getConfigurationName(), this.configuration.getSolrConfiguration(), this.configuration.getSolrSchema());
        }
        SolrClientUtils.createCollection(this.getHost(), this.getSolrPort(), this.configuration.getCollectionName(), this.configuration.getConfigurationName());
    }
}

