/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.template;

import java.io.Serializable;
import java.util.Iterator;
import org.testcontainers.shaded.freemarker.ext.util.WrapperTemplateModel;
import org.testcontainers.shaded.freemarker.template.AdapterTemplateModel;
import org.testcontainers.shaded.freemarker.template.ObjectWrapper;
import org.testcontainers.shaded.freemarker.template.SuppressFBWarnings;
import org.testcontainers.shaded.freemarker.template.TemplateCollectionModel;
import org.testcontainers.shaded.freemarker.template.TemplateModel;
import org.testcontainers.shaded.freemarker.template.TemplateModelException;
import org.testcontainers.shaded.freemarker.template.TemplateModelIterator;
import org.testcontainers.shaded.freemarker.template.TemplateModelWithAPISupport;
import org.testcontainers.shaded.freemarker.template.WrappingTemplateModel;
import org.testcontainers.shaded.freemarker.template.utility.ObjectWrapperWithAPISupport;

public class DefaultIteratorAdapter
extends WrappingTemplateModel
implements TemplateCollectionModel,
AdapterTemplateModel,
WrapperTemplateModel,
TemplateModelWithAPISupport,
Serializable {
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="We hope it's Seralizable")
    private final Iterator iterator;
    private boolean iteratorOwnedBySomeone;

    public static DefaultIteratorAdapter adapt(Iterator iterator, ObjectWrapper wrapper) {
        return new DefaultIteratorAdapter(iterator, wrapper);
    }

    private DefaultIteratorAdapter(Iterator iterator, ObjectWrapper wrapper) {
        super(wrapper);
        this.iterator = iterator;
    }

    @Override
    public Object getWrappedObject() {
        return this.iterator;
    }

    public Object getAdaptedObject(Class hint) {
        return this.getWrappedObject();
    }

    @Override
    public TemplateModelIterator iterator() throws TemplateModelException {
        return new SimpleTemplateModelIterator();
    }

    @Override
    public TemplateModel getAPI() throws TemplateModelException {
        return ((ObjectWrapperWithAPISupport)this.getObjectWrapper()).wrapAsAPI(this.iterator);
    }

    private class SimpleTemplateModelIterator
    implements TemplateModelIterator {
        private boolean iteratorOwnedByMe;

        private SimpleTemplateModelIterator() {
        }

        @Override
        public TemplateModel next() throws TemplateModelException {
            if (!this.iteratorOwnedByMe) {
                this.checkNotOwner();
                DefaultIteratorAdapter.this.iteratorOwnedBySomeone = true;
                this.iteratorOwnedByMe = true;
            }
            if (!DefaultIteratorAdapter.this.iterator.hasNext()) {
                throw new TemplateModelException("The collection has no more items.");
            }
            Object value = DefaultIteratorAdapter.this.iterator.next();
            return value instanceof TemplateModel ? (TemplateModel)value : DefaultIteratorAdapter.this.wrap(value);
        }

        @Override
        public boolean hasNext() throws TemplateModelException {
            if (!this.iteratorOwnedByMe) {
                this.checkNotOwner();
            }
            return DefaultIteratorAdapter.this.iterator.hasNext();
        }

        private void checkNotOwner() throws TemplateModelException {
            if (DefaultIteratorAdapter.this.iteratorOwnedBySomeone) {
                throw new TemplateModelException("This collection value wraps a java.util.Iterator, thus it can be listed only once.");
            }
        }
    }
}

