/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.nginx;

import java.net.MalformedURLException;
import java.net.URL;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class NginxContainer
extends GenericContainer<NginxContainer> {
    private static final int NGINX_DEFAULT_PORT = 80;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"nginx");

    public NginxContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public NginxContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPort(80);
        this.setCommand(new String[]{"nginx", "-g", "daemon off;"});
    }

    public URL getBaseUrl(String scheme, int port) throws MalformedURLException {
        return new URL(scheme + "://" + this.getHost() + ":" + this.getMappedPort(port));
    }
}

