/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.k6;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class K6Container
extends GenericContainer<K6Container> {
    private static final DockerImageName K6_IMAGE = DockerImageName.parse((String)"grafana/k6");
    private String testScript;
    private List<String> cmdOptions = new ArrayList<String>();
    private Map<String, String> scriptVars = new HashMap<String, String>();

    public K6Container(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public K6Container(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{K6_IMAGE});
    }

    public K6Container withTestScript(MountableFile testScript) {
        this.testScript = "/home/k6/" + FilenameUtils.getName((String)testScript.getResolvedPath());
        this.withCopyFileToContainer(testScript, this.testScript);
        return (K6Container)this.self();
    }

    public K6Container withCmdOptions(String ... options) {
        this.cmdOptions.addAll(Arrays.asList(options));
        return (K6Container)this.self();
    }

    public K6Container withScriptVar(String key, String value) {
        this.scriptVars.put(key, value);
        return (K6Container)this.self();
    }

    protected void configure() {
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add("run");
        commandParts.addAll(this.cmdOptions);
        for (Map.Entry<String, String> entry : this.scriptVars.entrySet()) {
            commandParts.add("--env");
            commandParts.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        commandParts.add(this.testScript);
        this.setCommand(commandParts.toArray(new String[0]));
    }
}

