/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.rnorth.ducttape.timeouts.Timeouts;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.DefaultRecordingFileFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.RecordingFileFactory;
import org.testcontainers.containers.SeleniumUtils;
import org.testcontainers.containers.VncRecordingContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.traits.VncService;
import org.testcontainers.containers.wait.HostPortWaitStrategy;
import org.testcontainers.containers.wait.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.WaitAllStrategy;
import org.testcontainers.containers.wait.WaitStrategy;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;
import org.testcontainers.shaded.com.google.common.collect.ImmutableSet;

public class BrowserWebDriverContainer<SELF extends BrowserWebDriverContainer<SELF>>
extends GenericContainer<SELF>
implements VncService,
LinkableContainer,
TestLifecycleAware {
    private static final String CHROME_IMAGE = "selenium/standalone-chrome-debug:%s";
    private static final String FIREFOX_IMAGE = "selenium/standalone-firefox-debug:%s";
    private static final String DEFAULT_PASSWORD = "secret";
    private static final int SELENIUM_PORT = 4444;
    private static final int VNC_PORT = 5900;
    @Nullable
    private DesiredCapabilities desiredCapabilities;
    private boolean customImageNameIsSet = false;
    @Nullable
    private RemoteWebDriver driver;
    private VncRecordingMode recordingMode = VncRecordingMode.RECORD_FAILING;
    private RecordingFileFactory recordingFileFactory;
    private File vncRecordingDirectory = new File("/tmp");
    private VncRecordingContainer vncRecordingContainer = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserWebDriverContainer.class);

    public BrowserWebDriverContainer() {
        WaitStrategy logWaitStrategy = new LogMessageWaitStrategy().withRegEx(".*(RemoteWebDriver instances should connect to|Selenium Server is up and running).*\n").withStartupTimeout(Duration.of(15L, ChronoUnit.SECONDS));
        this.waitStrategy = new WaitAllStrategy().withStrategy(logWaitStrategy).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(Duration.of(15L, ChronoUnit.SECONDS));
        this.withRecordingFileFactory(new DefaultRecordingFileFactory());
    }

    public BrowserWebDriverContainer(String dockerImageName) {
        this();
        super.setDockerImageName(dockerImageName);
        this.customImageNameIsSet = true;
        this.recordingMode = VncRecordingMode.SKIP;
    }

    public SELF withDesiredCapabilities(DesiredCapabilities desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        Integer seleniumPort = this.getMappedPort(4444);
        if (this.recordingMode == VncRecordingMode.SKIP) {
            return ImmutableSet.of((Object)seleniumPort);
        }
        return ImmutableSet.of((Object)seleniumPort, (Object)this.getMappedPort(5900));
    }

    protected void configure() {
        String timeZone;
        if (this.desiredCapabilities == null) {
            throw new IllegalStateException();
        }
        if (this.recordingMode != VncRecordingMode.SKIP) {
            if (this.getNetwork() == null) {
                this.withNetwork(Network.SHARED);
            }
            this.vncRecordingContainer = new VncRecordingContainer((GenericContainer)this).withVncPassword(DEFAULT_PASSWORD).withVncPort(5900);
        }
        if (!this.customImageNameIsSet) {
            super.setDockerImageName(BrowserWebDriverContainer.getImageForCapabilities(this.desiredCapabilities));
        }
        if ((timeZone = System.getProperty("user.timezone")) == null || timeZone.isEmpty()) {
            timeZone = "Etc/UTC";
        }
        this.addExposedPorts(new int[]{4444, 5900});
        this.addEnv("TZ", timeZone);
        this.addEnv("no_proxy", "localhost");
        this.setCommand("/opt/bin/entry_point.sh");
        this.setStartupAttempts(3);
    }

    public static String getImageForCapabilities(DesiredCapabilities desiredCapabilities) {
        String browserName;
        String seleniumVersion = SeleniumUtils.determineClasspathSeleniumVersion();
        switch (browserName = desiredCapabilities.getBrowserName()) {
            case "chrome": {
                return String.format(CHROME_IMAGE, seleniumVersion);
            }
            case "firefox": {
                return String.format(FIREFOX_IMAGE, seleniumVersion);
            }
        }
        throw new UnsupportedOperationException("Browser name must be 'chrome' or 'firefox'; provided '" + browserName + "' is not supported");
    }

    public URL getSeleniumAddress() {
        try {
            return new URL("http", this.getContainerIpAddress(), this.getMappedPort(4444), "/wd/hub");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getVncAddress() {
        return "vnc://vnc:secret@" + this.getContainerIpAddress() + ":" + this.getMappedPort(5900);
    }

    public String getPassword() {
        return DEFAULT_PASSWORD;
    }

    public int getPort() {
        return 5900;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.driver = (RemoteWebDriver)Unreliables.retryUntilSuccess((int)30, (TimeUnit)TimeUnit.SECONDS, (Callable)((Callable)Timeouts.getWithTimeout((int)10, (TimeUnit)TimeUnit.SECONDS, () -> () -> new RemoteWebDriver(this.getSeleniumAddress(), (Capabilities)this.desiredCapabilities))));
        if (this.vncRecordingContainer != null) {
            LOGGER.debug("Starting VNC recording");
            this.vncRecordingContainer.start();
        }
    }

    public RemoteWebDriver getWebDriver() {
        return this.driver;
    }

    public void afterTest(TestDescription description, Optional<Throwable> throwable) {
        this.retainRecordingIfNeeded(description.getFilesystemFriendlyName(), throwable.isPresent());
    }

    public void stop() {
        if (this.driver != null) {
            try {
                this.driver.quit();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to quit the driver", (Throwable)e);
            }
        }
        if (this.vncRecordingContainer != null) {
            try {
                this.vncRecordingContainer.stop();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to stop vncRecordingContainer", (Throwable)e);
            }
        }
        super.stop();
    }

    private void retainRecordingIfNeeded(String prefix, boolean succeeded) {
        boolean shouldRecord;
        switch (this.recordingMode) {
            case RECORD_ALL: {
                shouldRecord = true;
                break;
            }
            case RECORD_FAILING: {
                shouldRecord = !succeeded;
                break;
            }
            default: {
                shouldRecord = false;
            }
        }
        if (shouldRecord) {
            File recordingFile = this.recordingFileFactory.recordingFileForTest(this.vncRecordingDirectory, prefix, succeeded);
            LOGGER.info("Screen recordings for test {} will be stored at: {}", (Object)prefix, (Object)recordingFile);
            this.vncRecordingContainer.saveRecordingToFile(recordingFile);
        }
    }

    @Deprecated
    public SELF withLinkToContainer(LinkableContainer otherContainer, String alias) {
        this.addLink(otherContainer, alias);
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withRecordingMode(VncRecordingMode recordingMode, File vncRecordingDirectory) {
        this.recordingMode = recordingMode;
        this.vncRecordingDirectory = vncRecordingDirectory;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withRecordingFileFactory(RecordingFileFactory recordingFileFactory) {
        this.recordingFileFactory = recordingFileFactory;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public static enum VncRecordingMode {
        SKIP,
        RECORD_ALL,
        RECORD_FAILING;

    }
}

