/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public interface Transferable {
    public static final int DEFAULT_FILE_MODE = 33188;
    public static final int DEFAULT_DIR_MODE = 16877;

    default public int getFileMode() {
        return 33188;
    }

    public long getSize();

    default public void transferTo(TarArchiveOutputStream tarArchiveOutputStream, String destination) {
        TarArchiveEntry tarEntry = new TarArchiveEntry(destination);
        tarEntry.setSize(this.getSize());
        tarEntry.setMode(this.getFileMode());
        try {
            tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
            IOUtils.write(this.getBytes(), (OutputStream)tarArchiveOutputStream);
            tarArchiveOutputStream.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't transfer " + this.getDescription(), e);
        }
    }

    default public byte[] getBytes() {
        return new byte[0];
    }

    public String getDescription();
}

