/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.exception.UnauthorizedException;
import com.github.dockerjava.api.model.AuthResponse;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.javax.ws.rs.client.Entity;
import org.testcontainers.shaded.javax.ws.rs.client.WebTarget;
import org.testcontainers.shaded.javax.ws.rs.core.Response;

public class AuthCmdExec
extends AbstrSyncDockerCmdExec<AuthCmd, AuthResponse>
implements AuthCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthCmdExec.class);

    public AuthCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected AuthResponse execute(AuthCmd command) {
        WebTarget webResource = this.getBaseResource().path("/auth");
        LOGGER.trace("POST: {}", (Object)webResource);
        Response response = webResource.request().accept("application/json").post(Entity.entity(command.getAuthConfig(), "application/json"));
        if (response.getStatus() == 401) {
            throw new UnauthorizedException("Unauthorized");
        }
        return response.readEntity(AuthResponse.class);
    }
}

