/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.util;

import com.github.dockerjava.core.util.FilePathUtil;
import com.github.dockerjava.core.util.TarDirWalker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.testcontainers.shaded.com.google.common.io.ByteStreams;

public class CompressArchiveUtil {
    private CompressArchiveUtil() {
    }

    static void putTarEntry(TarArchiveOutputStream tarOutputStream, TarArchiveEntry tarEntry, Path file) throws IOException {
        tarEntry.setSize(Files.size(file));
        tarOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            ByteStreams.copy(input, (OutputStream)tarOutputStream);
            tarOutputStream.closeArchiveEntry();
        }
    }

    private static TarArchiveOutputStream buildTarStream(Path outputPath, boolean gZipped) throws IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));
        if (gZipped) {
            outputStream = new GzipCompressorOutputStream((OutputStream)outputStream);
        }
        TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)outputStream);
        tarArchiveOutputStream.setLongFileMode(2);
        return tarArchiveOutputStream;
    }

    public static void tar(Path inputPath, Path outputPath, boolean gZipped, boolean childrenOnly) throws IOException {
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new FileNotFoundException("File not found " + inputPath);
        }
        FileUtils.touch(outputPath.toFile());
        try (TarArchiveOutputStream tarArchiveOutputStream = CompressArchiveUtil.buildTarStream(outputPath, gZipped);){
            if (!Files.isDirectory(inputPath, new LinkOption[0])) {
                TarArchiveEntry tarEntry = new TarArchiveEntry(inputPath.getFileName().toString());
                if (inputPath.toFile().canExecute()) {
                    tarEntry.setMode(tarEntry.getMode() | 0x1ED);
                }
                CompressArchiveUtil.putTarEntry(tarArchiveOutputStream, tarEntry, inputPath);
            } else {
                Path sourcePath = inputPath;
                if (!childrenOnly) {
                    sourcePath = inputPath.getParent();
                }
                Files.walkFileTree(inputPath, new TarDirWalker(sourcePath, tarArchiveOutputStream));
            }
            tarArchiveOutputStream.flush();
        }
    }

    public static File archiveTARFiles(File base, Iterable<File> files, String archiveNameWithOutExtension) throws IOException {
        File tarFile = new File(FileUtils.getTempDirectoryPath(), archiveNameWithOutExtension + ".tar");
        tarFile.deleteOnExit();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile))));){
            tos.setLongFileMode(2);
            for (File file : files) {
                TarArchiveEntry tarEntry = new TarArchiveEntry(file);
                tarEntry.setName(FilePathUtil.relativize(base, file));
                if (!file.isDirectory() && file.canExecute()) {
                    tarEntry.setMode(tarEntry.getMode() | 0x1ED);
                }
                tos.putArchiveEntry((ArchiveEntry)tarEntry);
                if (!file.isDirectory()) {
                    FileUtils.copyFile(file, (OutputStream)tos);
                }
                tos.closeArchiveEntry();
            }
        }
        return tarFile;
    }
}

