/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.testcontainers.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;

public class AuthConfigFile {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, AuthConfig>> CONFIG_CFG_MAP_TYPE = new TypeReference<Map<String, AuthConfig>>(){};
    private static final TypeReference<Map<String, Map<String, AuthConfig>>> CONFIG_JSON_MAP_TYPE = new TypeReference<Map<String, Map<String, AuthConfig>>>(){};
    private final Map<String, AuthConfig> authConfigMap = new HashMap<String, AuthConfig>();

    void addConfig(AuthConfig config) {
        this.authConfigMap.put(config.getRegistryAddress(), config);
    }

    public AuthConfig resolveAuthConfig(String hostname) {
        if (StringUtils.isEmpty((String)hostname) || "https://index.docker.io/v1/".equals(hostname)) {
            return this.authConfigMap.get("https://index.docker.io/v1/");
        }
        AuthConfig c = this.authConfigMap.get(hostname);
        if (c != null) {
            return c;
        }
        String normalizedHostname = AuthConfigFile.convertToHostname(hostname);
        for (Map.Entry<String, AuthConfig> entry : this.authConfigMap.entrySet()) {
            String registry = entry.getKey();
            AuthConfig config = entry.getValue();
            if (!AuthConfigFile.convertToHostname(registry).equals(normalizedHostname)) continue;
            return config;
        }
        return null;
    }

    public AuthConfigurations getAuthConfigurations() {
        AuthConfigurations authConfigurations = new AuthConfigurations();
        for (Map.Entry<String, AuthConfig> authConfigEntry : this.authConfigMap.entrySet()) {
            authConfigurations.addConfig(authConfigEntry.getValue());
        }
        return authConfigurations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authConfigMap == null ? 0 : this.authConfigMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthConfigFile other = (AuthConfigFile)obj;
        return !(this.authConfigMap == null ? other.authConfigMap != null : !this.authConfigMap.equals(other.authConfigMap));
    }

    public String toString() {
        return "AuthConfigFile [authConfigMap=" + this.authConfigMap + "]";
    }

    public static AuthConfigFile loadConfig(File confFile) throws IOException {
        AuthConfigFile configFile = new AuthConfigFile();
        if (!confFile.exists()) {
            return new AuthConfigFile();
        }
        Map configMap = null;
        try {
            Map configJson = (Map)MAPPER.readValue(confFile, CONFIG_JSON_MAP_TYPE);
            if (configJson != null) {
                configMap = (Map)configJson.get("auths");
            }
        }
        catch (IOException e1) {
            try {
                configMap = (Map)MAPPER.readValue(confFile, CONFIG_CFG_MAP_TYPE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (configMap != null) {
            for (Map.Entry entry : configMap.entrySet()) {
                AuthConfig authConfig = (AuthConfig)entry.getValue();
                AuthConfigFile.decodeAuth(authConfig.getAuth(), authConfig);
                authConfig.withAuth(null);
                authConfig.withRegistryAddress((String)entry.getKey());
                configFile.addConfig(authConfig);
            }
        } else {
            List<String> authFileContent = FileUtils.readLines(confFile);
            if (authFileContent.size() < 2) {
                throw new IOException("The Auth Config file is empty");
            }
            AuthConfig config = new AuthConfig();
            String[] origAuth = authFileContent.get(0).split(" = ");
            if (origAuth.length != 2) {
                throw new IOException("Invalid Auth config file");
            }
            AuthConfigFile.decodeAuth(origAuth[1], config);
            String[] origEmail = authFileContent.get(1).split(" = ");
            if (origEmail.length != 2) {
                throw new IOException("Invalid Auth config file");
            }
            config.withEmail(origEmail[1]);
            configFile.addConfig(config);
        }
        return configFile;
    }

    static void decodeAuth(String auth, AuthConfig config) throws IOException {
        String str = new String(Base64.decodeBase64((String)auth), Charset.forName("UTF-8"));
        String[] parts = str.split(":", 2);
        if (parts.length != 2) {
            throw new IOException("Invalid auth configuration file");
        }
        config.withUsername(parts[0]);
        config.withPassword(parts[1]);
    }

    static String convertToHostname(String server) {
        String stripped = server;
        if (server.startsWith("http://")) {
            stripped = server.substring(7);
        } else if (server.startsWith("https://")) {
            stripped = server.substring(8);
        }
        String[] numParts = stripped.split("/", 2);
        return numParts[0];
    }
}

