/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;

public class WindowsClientProviderStrategy
extends DockerClientProviderStrategy {
    private static final int PING_TIMEOUT_DEFAULT = 5;
    private static final String PING_TIMEOUT_PROPERTY_NAME = "testcontainers.windowsprovider.timeout";

    @Override
    public void test() throws DockerClientProviderStrategy.InvalidConfigurationException {
        this.config = this.tryConfiguration("tcp://localhost:2375");
    }

    @Override
    public String getDescription() {
        return "Docker for Windows (via TCP port 2375)";
    }

    @NotNull
    protected DockerClientConfig tryConfiguration(String dockerHost) {
        this.config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(dockerHost).withDockerTlsVerify(false).build();
        this.client = this.getClientForConfig(this.config);
        int timeout = Integer.getInteger(PING_TIMEOUT_PROPERTY_NAME, 5);
        this.ping(this.client, timeout);
        return this.config;
    }
}

