/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.output;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.OutputFrame;

public class WaitingConsumer
implements Consumer<OutputFrame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitingConsumer.class);
    private LinkedBlockingDeque<OutputFrame> frames = new LinkedBlockingDeque();

    @Override
    public void accept(OutputFrame frame) {
        this.frames.add(frame);
    }

    public LinkedBlockingDeque<OutputFrame> getFrames() {
        return this.frames;
    }

    public void waitUntil(Predicate<OutputFrame> predicate) throws TimeoutException {
        this.waitUntil(predicate, Long.MAX_VALUE, 1);
    }

    public void waitUntil(Predicate<OutputFrame> predicate, int limit, TimeUnit limitUnit) throws TimeoutException {
        this.waitUntil(predicate, limit, limitUnit, 1);
    }

    public void waitUntil(Predicate<OutputFrame> predicate, long limit, TimeUnit limitUnit, int times) throws TimeoutException {
        long expiry = limitUnit.toMillis(limit) + System.currentTimeMillis();
        this.waitUntil(predicate, expiry, times);
    }

    private void waitUntil(Predicate<OutputFrame> predicate, long expiry, int times) throws TimeoutException {
        int numberOfMatches = 0;
        while (System.currentTimeMillis() < expiry) {
            try {
                OutputFrame frame = this.frames.pollLast(100L, TimeUnit.MILLISECONDS);
                if (frame != null) {
                    String trimmedFrameText = frame.getUtf8String().replaceFirst("\n$", "");
                    LOGGER.debug("{}: {}", (Object)frame.getType(), (Object)trimmedFrameText);
                    if (predicate.test(frame) && ++numberOfMatches == times) {
                        return;
                    }
                }
                if (!this.frames.isEmpty()) continue;
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new TimeoutException();
    }

    public void waitUntilEnd() throws TimeoutException {
        this.waitUntilEnd(Long.MAX_VALUE);
    }

    public void waitUntilEnd(long limit, TimeUnit limitUnit) throws TimeoutException {
        long expiry = limitUnit.toMillis(limit) + System.currentTimeMillis();
        this.waitUntilEnd(expiry);
    }

    private void waitUntilEnd(Long expiry) throws TimeoutException {
        while (System.currentTimeMillis() < expiry) {
            try {
                OutputFrame frame = this.frames.pollLast(100L, TimeUnit.MILLISECONDS);
                if (frame == OutputFrame.END) {
                    return;
                }
                if (!this.frames.isEmpty()) continue;
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new TimeoutException("Expiry time reached before end of output");
    }
}

