/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.DockerMachineClientProviderStrategy;
import org.testcontainers.dockerclient.EnvironmentAndSystemPropertyClientProviderStrategy;
import org.testcontainers.dockerclient.LogToStringContainerCallback;
import org.testcontainers.dockerclient.ProxiedUnixSocketClientProviderStrategy;
import org.testcontainers.dockerclient.UnixSocketClientProviderStrategy;
import org.testcontainers.dockerclient.WindowsClientProviderStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class DockerClientFactory {
    private static final Logger log = LoggerFactory.getLogger(DockerClientFactory.class);
    private final Object $lock = new Object[0];
    private static final String TINY_IMAGE = TestcontainersConfiguration.getInstance().getTinyImage();
    private static DockerClientFactory instance;
    private DockerClientProviderStrategy strategy;
    private boolean preconditionsChecked = false;
    private static final List<DockerClientProviderStrategy> CONFIGURATION_STRATEGIES;
    private String activeApiVersion;
    private String activeExecutionDriver;

    private DockerClientFactory() {
    }

    public static synchronized DockerClientFactory instance() {
        if (instance == null) {
            instance = new DockerClientFactory();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient client() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.strategy != null) {
                return this.strategy.getClient();
            }
            this.strategy = DockerClientProviderStrategy.getFirstValidStrategy(CONFIGURATION_STRATEGIES);
            log.info("Docker host IP address is {}", (Object)this.strategy.getDockerHostIpAddress());
            DockerClient client = this.strategy.getClient();
            if (!this.preconditionsChecked) {
                Info dockerInfo = (Info)client.infoCmd().exec();
                Version version = (Version)client.versionCmd().exec();
                this.activeApiVersion = version.getApiVersion();
                this.activeExecutionDriver = dockerInfo.getExecutionDriver();
                log.info("Connected to docker: \n  Server Version: " + dockerInfo.getServerVersion() + "\n  API Version: " + this.activeApiVersion + "\n  Operating System: " + dockerInfo.getOperatingSystem() + "\n  Total Memory: " + dockerInfo.getMemTotal() / 0x100000L + " MB");
                this.checkVersion(version.getVersion());
                this.checkDiskSpaceAndHandleExceptions(client);
                this.preconditionsChecked = true;
            }
            return client;
        }
    }

    private void checkAndPullImage(DockerClient client, String image) {
        List images = (List)client.listImagesCmd().withImageNameFilter(image).exec();
        if (images.isEmpty()) {
            client.pullImageCmd(image).exec(new PullImageResultCallback()).awaitSuccess();
        }
    }

    public String dockerHostIpAddress() {
        return this.strategy.getDockerHostIpAddress();
    }

    private void checkVersion(String version) {
        String[] splitVersion = version.split("\\.");
        if (Integer.valueOf(splitVersion[0]) <= 1 && Integer.valueOf(splitVersion[1]) < 6) {
            throw new IllegalStateException("Docker version 1.6.0+ is required, but version " + version + " was found");
        }
    }

    private void checkDiskSpaceAndHandleExceptions(DockerClient client) {
        try {
            this.checkDiskSpace(client);
        }
        catch (NotEnoughDiskSpaceException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("Encountered and ignored error while checking disk space", e);
        }
    }

    private void checkDiskSpace(DockerClient client) {
        DiskSpaceUsage df = this.runInsideDocker(client, cmd -> cmd.withCmd("df", "-P"), (dockerClient, id) -> {
            String logResults = dockerClient.logContainerCmd((String)id).withStdOut(true).exec(new LogToStringContainerCallback()).toString();
            return this.parseAvailableDiskSpace(logResults);
        });
        log.info("Disk utilization in Docker environment is {} ({} )", (Object)df.usedPercent.map(x -> x + "%").orElse("unknown"), (Object)df.availableMB.map(x -> x + " MB available").orElse("unknown available"));
        if (df.availableMB.map(it -> it < 2048).orElse(false).booleanValue()) {
            log.error("Docker environment has less than 2GB free - execution is unlikely to succeed so will be aborted.");
            throw new NotEnoughDiskSpaceException("Not enough disk space in Docker environment");
        }
    }

    public <T> T runInsideDocker(Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        if (this.strategy == null) {
            this.client();
        }
        return this.runInsideDocker(this.strategy.getClient(), createContainerCmdConsumer, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runInsideDocker(DockerClient client, Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        this.checkAndPullImage(client, TINY_IMAGE);
        CreateContainerCmd createContainerCmd = client.createContainerCmd(TINY_IMAGE);
        createContainerCmdConsumer.accept(createContainerCmd);
        String id = createContainerCmd.exec().getId();
        client.startContainerCmd(id).exec();
        try {
            T t = block.apply(client, id);
            return t;
        }
        finally {
            try {
                client.removeContainerCmd(id).withRemoveVolumes(true).withForce(true).exec();
            }
            catch (InternalServerErrorException | NotFoundException ignored) {
                log.debug("", ignored);
            }
        }
    }

    private DiskSpaceUsage parseAvailableDiskSpace(String dfOutput) {
        String[] lines;
        DiskSpaceUsage df = new DiskSpaceUsage();
        for (String line : lines = dfOutput.split("\n")) {
            String[] fields = line.split("\\s+");
            if (!fields[5].equals("/")) continue;
            int availableKB = Integer.valueOf(fields[3]);
            df.availableMB = Optional.of(availableKB / 1024);
            df.usedPercent = Optional.of(Integer.valueOf(fields[4].replace("%", "")));
        }
        return df;
    }

    public String getActiveApiVersion() {
        if (!this.preconditionsChecked) {
            this.client();
        }
        return this.activeApiVersion;
    }

    public String getActiveExecutionDriver() {
        if (!this.preconditionsChecked) {
            this.client();
        }
        return this.activeExecutionDriver;
    }

    public boolean isUsing(Class<? extends DockerClientProviderStrategy> providerStrategyClass) {
        return providerStrategyClass.isAssignableFrom(this.strategy.getClass());
    }

    static {
        CONFIGURATION_STRATEGIES = Arrays.asList(new EnvironmentAndSystemPropertyClientProviderStrategy(), new UnixSocketClientProviderStrategy(), new ProxiedUnixSocketClientProviderStrategy(), new DockerMachineClientProviderStrategy(), new WindowsClientProviderStrategy());
        System.setProperty("org.testcontainers.shaded.io.netty.packagePrefix", "org.testcontainers.shaded.");
    }

    private static class NotEnoughDiskSpaceException
    extends RuntimeException {
        NotEnoughDiskSpaceException(String message) {
            super(message);
        }
    }

    private static class DiskSpaceUsage {
        Optional<Integer> availableMB = Optional.empty();
        Optional<Integer> usedPercent = Optional.empty();

        private DiskSpaceUsage() {
        }
    }
}

