/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs.filter;

import com.github.dockerjava.jaxrs.filter.LoggingFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.testcontainers.shaded.javax.ws.rs.client.ClientRequestContext;

public class SelectiveLoggingFilter
extends LoggingFilter {
    private static final Set<String> SKIPPED_CONTENT;

    public SelectiveLoggingFilter(Logger logger, Boolean b) {
        super(logger, b);
    }

    @Override
    public void filter(ClientRequestContext context) throws IOException {
        Object contentType = context.getHeaders().getFirst("Content-Type");
        if (contentType == null || !SKIPPED_CONTENT.contains(contentType.toString())) {
            super.filter(context);
        }
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("application/octet-stream");
        s.add("application/tar");
        SKIPPED_CONTENT = Collections.unmodifiableSet(s);
    }
}

